/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.internal.metadata;

import java.util.ArrayList;
import java.util.List;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.maven.spi.metadata.MetadataMapper;
import org.commonjava.maven.galley.maven.util.ArtifactPathUtils;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;

public class StandardMetadataMapper
implements MetadataMapper {
    @Override
    public List<ConcreteResource> createResource(List<Location> locations, String f, ProjectRef projectRef, String groupId) throws TransferException {
        ArrayList<ConcreteResource> results = new ArrayList<ConcreteResource>();
        for (Location location : locations) {
            results.add(this.createResource(location, f, projectRef, groupId));
        }
        return results;
    }

    @Override
    public ConcreteResource createResource(Location location, String f, ProjectRef projectRef, String groupId) throws TransferException {
        String fileName = this.establishFileName(f, location);
        String p = projectRef == null ? ArtifactPathUtils.formatMetadataPath(groupId, fileName) : ArtifactPathUtils.formatMetadataPath(projectRef, fileName);
        return new ConcreteResource(location, p);
    }

    protected String establishFileName(String fileName, Location location) {
        if (fileName == null) {
            switch (location.getUri().substring(0, 4)) {
                case "file": {
                    fileName = "maven-metadata-local.xml";
                    break;
                }
                default: {
                    fileName = "maven-metadata.xml";
                }
            }
        }
        return fileName;
    }
}

