/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Resource;
import org.commonjava.maven.galley.model.TransferBatch;
import org.commonjava.maven.galley.model.VirtualResource;

public class ArtifactBatch
extends TransferBatch
implements Iterable<ArtifactRef> {
    private final Map<ArtifactRef, List<? extends Location>> artifacts;
    private Map<ArtifactRef, List<ConcreteResource>> artifactMappings;

    public ArtifactBatch(List<? extends Location> locations, Collection<ArtifactRef> artifacts) {
        this.artifacts = new HashMap<ArtifactRef, List<? extends Location>>();
        for (ArtifactRef artifact : artifacts) {
            this.artifacts.put(artifact, locations);
        }
    }

    public ArtifactBatch(Map<ArtifactRef, List<? extends Location>> artifacts) {
        this.artifacts = artifacts;
    }

    public void setArtifactToResourceMapping(Map<ArtifactRef, Resource> mappings) {
        this.artifactMappings = new HashMap<ArtifactRef, List<ConcreteResource>>();
        HashSet<ConcreteResource> resources = new HashSet<ConcreteResource>();
        for (Map.Entry<ArtifactRef, Resource> entry : mappings.entrySet()) {
            ArtifactRef artifact = entry.getKey();
            Resource resource = entry.getValue();
            if (resource instanceof ConcreteResource) {
                this.artifactMappings.put(artifact, Collections.singletonList((ConcreteResource)resource));
                resources.add((ConcreteResource)resource);
                continue;
            }
            List<ConcreteResource> res = ((VirtualResource)resource).toConcreteResources();
            this.artifactMappings.put(artifact, res);
            resources.addAll(res);
        }
        this.setResources(resources);
    }

    public Map<ArtifactRef, List<ConcreteResource>> getArtifactToConcreteResourceMapping() {
        return this.artifactMappings;
    }

    public List<? extends Location> getLocations(ArtifactRef ref) {
        return this.artifacts.get(ref);
    }

    public Set<ArtifactRef> getArtifactRefs() {
        return this.artifacts.keySet();
    }

    @Override
    public Iterator<ArtifactRef> iterator() {
        return this.artifacts.keySet().iterator();
    }

    public int size() {
        return this.artifacts.size();
    }
}

