/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import javax.jms.JMSConsumer;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.hornetq.jms.client.HornetQJMSContext;
import org.hornetq.jms.client.JmsExceptionUtils;

public class HornetQJMSConsumer
implements JMSConsumer {
    private final HornetQJMSContext context;
    private final MessageConsumer consumer;

    HornetQJMSConsumer(HornetQJMSContext context, MessageConsumer consumer) {
        this.context = context;
        this.consumer = consumer;
    }

    @Override
    public String getMessageSelector() {
        try {
            return this.consumer.getMessageSelector();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public MessageListener getMessageListener() throws JMSRuntimeException {
        try {
            return this.consumer.getMessageListener();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        try {
            this.consumer.setMessageListener(new MessageListenerWrapper(listener));
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public Message receive() {
        try {
            return this.context.setLastMessage(this, this.consumer.receive());
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public Message receive(long timeout) {
        try {
            return this.context.setLastMessage(this, this.consumer.receive(timeout));
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public Message receiveNoWait() {
        try {
            return this.context.setLastMessage(this, this.consumer.receiveNoWait());
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.consumer.close();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBody(Class<T> c) {
        try {
            Message message = this.consumer.receive();
            this.context.setLastMessage(this, message);
            return message == null ? null : (T)message.getBody(c);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBody(Class<T> c, long timeout) {
        try {
            Message message = this.consumer.receive(timeout);
            this.context.setLastMessage(this, message);
            return message == null ? null : (T)message.getBody(c);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBodyNoWait(Class<T> c) {
        try {
            Message message = this.consumer.receiveNoWait();
            this.context.setLastMessage(this, message);
            return message == null ? null : (T)message.getBody(c);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    final class MessageListenerWrapper
    implements MessageListener {
        private final MessageListener wrapped;

        public MessageListenerWrapper(MessageListener wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void onMessage(Message message) {
            HornetQJMSConsumer.this.context.setLastMessage(HornetQJMSConsumer.this, message);
            HornetQJMSConsumer.this.context.getThreadAwareContext().setCurrentThread(false);
            try {
                this.wrapped.onMessage(message);
            }
            finally {
                HornetQJMSConsumer.this.context.getThreadAwareContext().clearCurrentThread(false);
            }
        }
    }
}

