/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;

public abstract class JGroupsBroadcastEndpoint
implements BroadcastEndpoint {
    private final String channelName;
    private boolean clientOpened;
    private boolean broadcastOpened;
    private JChannelWrapper channel;
    private JGroupsReceiver receiver;

    public JGroupsBroadcastEndpoint(String channelName) {
        this.channelName = channelName;
    }

    @Override
    public void broadcast(byte[] data) throws Exception {
        if (this.broadcastOpened) {
            Message msg = new Message();
            msg.setBuffer(data);
            this.channel.send(msg);
        }
    }

    @Override
    public byte[] receiveBroadcast() throws Exception {
        if (this.clientOpened) {
            return this.receiver.receiveBroadcast();
        }
        return null;
    }

    @Override
    public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
        if (this.clientOpened) {
            return this.receiver.receiveBroadcast(time, unit);
        }
        return null;
    }

    @Override
    public synchronized void openClient() throws Exception {
        if (this.clientOpened) {
            return;
        }
        this.internalOpen();
        this.receiver = new JGroupsReceiver();
        this.channel.addReceiver(this.receiver);
        this.clientOpened = true;
    }

    @Override
    public synchronized void openBroadcaster() throws Exception {
        if (this.broadcastOpened) {
            return;
        }
        this.internalOpen();
        this.broadcastOpened = true;
    }

    public abstract JChannel createChannel() throws Exception;

    public JGroupsBroadcastEndpoint initChannel() throws Exception {
        this.channel = JChannelManager.getJChannel(this.channelName, this);
        return this;
    }

    protected void internalOpen() throws Exception {
        this.channel.connect();
    }

    @Override
    public synchronized void close(boolean isBroadcast) throws Exception {
        if (isBroadcast) {
            this.broadcastOpened = false;
        } else {
            this.channel.removeReceiver(this.receiver);
            this.clientOpened = false;
        }
        this.internalCloseChannel();
    }

    protected synchronized void internalCloseChannel() {
        this.channel.close();
    }

    protected static class JChannelManager {
        private static Map<String, JChannelWrapper> channels;

        protected JChannelManager() {
        }

        public static synchronized JChannelWrapper getJChannel(String channelName, JGroupsBroadcastEndpoint endpoint) throws Exception {
            JChannelWrapper wrapper;
            if (channels == null) {
                channels = new HashMap<String, JChannelWrapper>();
            }
            if ((wrapper = channels.get(channelName)) == null) {
                wrapper = new JChannelWrapper(channelName, endpoint.createChannel());
                channels.put(channelName, wrapper);
                return wrapper;
            }
            return wrapper.addRef();
        }

        public static synchronized void closeChannel(String channelName, JChannel channel) {
            channel.setReceiver(null);
            channel.disconnect();
            channel.close();
            JChannelWrapper wrapper = channels.remove(channelName);
            if (wrapper == null) {
                throw new IllegalStateException("Did not find channel " + channelName);
            }
        }
    }

    protected static class JChannelWrapper {
        int refCount = 1;
        JChannel channel;
        String channelName;
        final List<JGroupsReceiver> receivers = new ArrayList<JGroupsReceiver>();

        public JChannelWrapper(String channelName, JChannel channel) throws Exception {
            this.channelName = channelName;
            this.channel = channel;
        }

        public synchronized void close() {
            --this.refCount;
            if (this.refCount == 0) {
                JChannelManager.closeChannel(this.channelName, this.channel);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeReceiver(JGroupsReceiver receiver) {
            List<JGroupsReceiver> list = this.receivers;
            synchronized (list) {
                this.receivers.remove(receiver);
            }
        }

        public synchronized void connect() throws Exception {
            if (this.channel.isConnected()) {
                return;
            }
            this.channel.setReceiver(new ReceiverAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void receive(Message msg) {
                    List<JGroupsReceiver> list = JChannelWrapper.this.receivers;
                    synchronized (list) {
                        for (JGroupsReceiver r : JChannelWrapper.this.receivers) {
                            r.receive(msg);
                        }
                    }
                }
            });
            this.channel.connect(this.channelName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addReceiver(JGroupsReceiver jGroupsReceiver) {
            List<JGroupsReceiver> list = this.receivers;
            synchronized (list) {
                this.receivers.add(jGroupsReceiver);
            }
        }

        public void send(Message msg) throws Exception {
            this.channel.send(msg);
        }

        public JChannelWrapper addRef() {
            ++this.refCount;
            return this;
        }

        public String toString() {
            return "JChannelWrapper of [" + this.channel + "] " + this.refCount + " " + this.channelName;
        }
    }

    private static final class JGroupsReceiver
    extends ReceiverAdapter {
        private final BlockingQueue<byte[]> dequeue = new LinkedBlockingDeque<byte[]>();

        private JGroupsReceiver() {
        }

        @Override
        public void receive(Message msg) {
            this.dequeue.add(msg.getBuffer());
        }

        public byte[] receiveBroadcast() throws Exception {
            return this.dequeue.take();
        }

        public byte[] receiveBroadcast(long time, TimeUnit unit) throws Exception {
            return this.dequeue.poll(time, unit);
        }
    }
}

