package org.jgroups.tests;


import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla3 {
    public static void main(String[] args) throws Exception {
        SocketAddress dest=new InetSocketAddress(7500);
        SocketChannel ch=SocketChannel.open();
        ch.configureBlocking(false);
        Selector sel=Selector.open();
        ch.connect(dest);
        boolean rc=ch.finishConnect();
        System.out.println("rc = " + rc);


        ByteBuffer buf=ByteBuffer.allocate(100);

        SelectionKey key=ch.register(sel, SelectionKey.OP_READ);
        boolean close=false;

        while(sel.isOpen()) {
            if(sel.select() > 0) {
                for(Iterator<SelectionKey> it=sel.selectedKeys().iterator(); it.hasNext();) {
                    SelectionKey k=it.next();
                    try {
                        if(!k.isValid())
                            continue;
                        if(k.isReadable()) {
                            if(close)
                                ch.close();
                            buf.clear();
                            int read=ch.read(buf);
                            System.out.println("read = " + read);
                            if(read > 0) {
                                buf.flip();
                                String str=new String(buf.array(), 0, buf.limit());
                                System.out.println("str = " + str);
                            }
                            else if(read < 0)
                                close=true;
                        }
                    }
                    catch(Throwable t) {
                        t.printStackTrace();
                    }
                    finally {
                        it.remove();
                    }
                }
            }
        }
    }
}
