/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectConsumerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionProducerCreditsFailMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionProducerCreditsMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveContinuationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveLargeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;

public final class CoreSessionCallback
implements SessionCallback {
    private final Channel channel;
    private ProtocolManager protocolManager;
    private String name;

    public CoreSessionCallback(String name, ProtocolManager protocolManager, Channel channel) {
        this.name = name;
        this.protocolManager = protocolManager;
        this.channel = channel;
    }

    @Override
    public int sendLargeMessage(ServerMessage message, ServerConsumer consumer, long bodySize, int deliveryCount) {
        SessionReceiveLargeMessage packet = new SessionReceiveLargeMessage(consumer.getID(), message, bodySize, deliveryCount);
        this.channel.send(packet);
        int size = packet.getPacketSize();
        return size;
    }

    @Override
    public int sendLargeMessageContinuation(ServerConsumer consumer, byte[] body, boolean continues, boolean requiresResponse) {
        SessionReceiveContinuationMessage packet = new SessionReceiveContinuationMessage(consumer.getID(), body, continues, requiresResponse);
        this.channel.send(packet);
        return packet.getPacketSize();
    }

    @Override
    public int sendMessage(ServerMessage message, ServerConsumer consumer, int deliveryCount) {
        SessionReceiveMessage packet = new SessionReceiveMessage(consumer.getID(), message, deliveryCount);
        int size = 0;
        if (this.channel.sendBatched(packet)) {
            size = packet.getPacketSize();
        }
        return size;
    }

    @Override
    public void sendProducerCreditsMessage(int credits, SimpleString address) {
        SessionProducerCreditsMessage packet = new SessionProducerCreditsMessage(credits, address);
        this.channel.send(packet);
    }

    @Override
    public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
        SessionProducerCreditsFailMessage packet = new SessionProducerCreditsFailMessage(credits, address);
        this.channel.send(packet);
    }

    @Override
    public void closed() {
        this.protocolManager.removeHandler(this.name);
    }

    @Override
    public void addReadyListener(ReadyListener listener) {
        this.channel.getConnection().getTransportConnection().addReadyListener(listener);
    }

    @Override
    public void removeReadyListener(ReadyListener listener) {
        this.channel.getConnection().getTransportConnection().removeReadyListener(listener);
    }

    @Override
    public void disconnect(ServerConsumer consumerId, String queueName) {
        if (this.channel.supports((byte)12)) {
            this.channel.send(new DisconnectConsumerMessage(consumerId.getID()));
        } else {
            ActiveMQServerLogger.LOGGER.warnDisconnectOldClient(queueName);
        }
    }

    @Override
    public boolean hasCredits(ServerConsumer consumer) {
        return true;
    }
}

