package org.jgroups.tests;

import org.jgroups.JChannel;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Util;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla4 {
    protected JChannel a, b;
    protected RpcDispatcher disp1, disp2;
    protected int cnt=0;

    public String sayHi(int num) {
        if(num == 2)
            return null;
        else
            return "hello-" + ++cnt;
    }

    protected void start() throws Throwable {
        a=new JChannel("/home/bela/clustered1.xml").name("A");
        disp1=new RpcDispatcher(a, this);
        b=new JChannel("/home/bela/clustered1.xml").name("B");
        disp2=new RpcDispatcher(b, this);
        a.connect("demo");
        b.connect("demo");

        Class[] types={int.class};
        boolean looping=true;
        while(looping) {
            int c=Util.keyPress("[1] send regular message [2] send empty message [x] exit");
            switch(c) {
                case '1':
                    String retval=disp1.callRemoteMethod(b.getAddress(), "sayHi", new Object[]{1}, types, RequestOptions.SYNC());
                    System.out.println("retval = " + retval);
                    break;
                case '2':
                    retval=disp1.callRemoteMethod(b.getAddress(), "sayHi", new Object[]{2}, types, RequestOptions.SYNC());
                    System.out.println("retval = " + retval);
                    break;
                case 'x':
                    looping=false;
                    break;
            }
        }
        Util.close(b, a);
    }

    public static void main(String[] args) throws Throwable {
        new bla4().start();
    }
}