/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.Collection;
import java.util.Map;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;

class ListFilterSpec
extends FilterSpec {
    private final boolean all;
    private final FilterSpec[] children;

    ListFilterSpec(boolean all, FilterSpec ... specs) {
        if (specs.length == 0) {
            throw new IllegalArgumentException("No child filters specified");
        }
        this.all = all;
        this.children = specs;
    }

    @Override
    public boolean matchesSimple(Map<String, AttributeValue> attributes) {
        for (FilterSpec child : this.children) {
            if (child.matchesSimple(attributes) == this.all) continue;
            return !this.all;
        }
        return this.all;
    }

    @Override
    public boolean matchesMulti(Map<String, ? extends Collection<AttributeValue>> attributes) {
        for (FilterSpec child : this.children) {
            if (child.matchesMulti(attributes) == this.all) continue;
            return !this.all;
        }
        return this.all;
    }

    @Override
    void toString(StringBuilder builder) {
        builder.append('(').append(this.all ? (char)'&' : '|');
        for (FilterSpec child : this.children) {
            child.toString(builder);
        }
        builder.append(')');
    }
}

