/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.protocols.http2.AbstractHttp2StreamSourceChannel;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.protocols.http2.Http2DataStreamSinkChannel;
import io.undertow.protocols.http2.Http2HeadersStreamSinkChannel;
import io.undertow.protocols.http2.Http2StreamSourceChannel;
import io.undertow.server.ConnectorStatisticsImpl;
import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpAttachments;
import io.undertow.server.protocol.http2.Http2ServerConnection;
import io.undertow.server.protocol.http2.Http2SslSessionInfo;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.ImmediatePooledByteBuffer;
import io.undertow.util.Methods;
import io.undertow.util.ParameterLimitException;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.net.ssl.SSLSession;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.channels.Channels;

public class Http2ReceiveListener
implements ChannelListener<Http2Channel> {
    static final HttpString METHOD = new HttpString(":method");
    static final HttpString PATH = new HttpString(":path");
    static final HttpString SCHEME = new HttpString(":scheme");
    static final HttpString AUTHORITY = new HttpString(":authority");
    private final HttpHandler rootHandler;
    private final long maxEntitySize;
    private final OptionMap undertowOptions;
    private final String encoding;
    private final boolean decode;
    private final StringBuilder decodeBuffer = new StringBuilder();
    private final boolean allowEncodingSlash;
    private final int bufferSize;
    private final int maxParameters;
    private final boolean recordRequestStartTime;
    private final ConnectorStatisticsImpl connectorStatistics;
    private static final AtomicIntegerFieldUpdater<Http2ReceiveListener> concurrentRequestsUpdater = AtomicIntegerFieldUpdater.newUpdater(Http2ReceiveListener.class, "concurrentRequests");
    private volatile int concurrentRequests;

    public Http2ReceiveListener(HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize, ConnectorStatisticsImpl connectorStatistics) {
        this.rootHandler = rootHandler;
        this.undertowOptions = undertowOptions;
        this.bufferSize = bufferSize;
        this.connectorStatistics = connectorStatistics;
        this.maxEntitySize = undertowOptions.get(UndertowOptions.MAX_ENTITY_SIZE, -1L);
        this.allowEncodingSlash = undertowOptions.get(UndertowOptions.ALLOW_ENCODED_SLASH, false);
        this.decode = undertowOptions.get(UndertowOptions.DECODE_URL, true);
        this.maxParameters = undertowOptions.get(UndertowOptions.MAX_PARAMETERS, 1000);
        this.recordRequestStartTime = undertowOptions.get(UndertowOptions.RECORD_REQUEST_START_TIME, false);
        this.encoding = undertowOptions.get(UndertowOptions.DECODE_URL, true) ? undertowOptions.get(UndertowOptions.URL_CHARSET, StandardCharsets.UTF_8.name()) : null;
    }

    @Override
    public void handleEvent(Http2Channel channel) {
        try {
            AbstractHttp2StreamSourceChannel frame = (AbstractHttp2StreamSourceChannel)channel.receive();
            if (frame == null) {
                return;
            }
            if (frame instanceof Http2StreamSourceChannel) {
                this.handleRequests(channel, (Http2StreamSourceChannel)frame);
            }
        }
        catch (IOException e) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
            IoUtils.safeClose((Closeable)channel);
        }
        catch (Throwable t) {
            UndertowLogger.REQUEST_IO_LOGGER.handleUnexpectedFailure(t);
            IoUtils.safeClose((Closeable)channel);
        }
    }

    private void handleRequests(Http2Channel channel, Http2StreamSourceChannel frame) {
        SSLSession session;
        Http2StreamSourceChannel dataChannel = frame;
        Http2ServerConnection connection = new Http2ServerConnection(channel, dataChannel, this.undertowOptions, this.bufferSize, this.rootHandler);
        if (!this.checkRequestHeaders(dataChannel.getHeaders())) {
            channel.sendRstStream(frame.getStreamId(), 1);
            try {
                Channels.drain(frame, Long.MAX_VALUE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        final HttpServerExchange exchange = new HttpServerExchange(connection, dataChannel.getHeaders(), dataChannel.getResponseChannel().getHeaders(), this.maxEntitySize);
        dataChannel.getResponseChannel().setTrailersProducer(new Http2DataStreamSinkChannel.TrailersProducer(){

            @Override
            public HeaderMap getTrailers() {
                return exchange.getAttachment(HttpAttachments.RESPONSE_TRAILERS);
            }
        });
        dataChannel.setTrailersHandler(new Http2StreamSourceChannel.TrailersHandler(){

            @Override
            public void handleTrailers(HeaderMap headerMap) {
                exchange.putAttachment(HttpAttachments.REQUEST_TRAILERS, headerMap);
            }
        });
        connection.setExchange(exchange);
        dataChannel.setMaxStreamSize(this.maxEntitySize);
        exchange.setRequestScheme(exchange.getRequestHeaders().getFirst(SCHEME));
        exchange.setProtocol(Protocols.HTTP_2_0);
        exchange.setRequestMethod(Methods.fromString(exchange.getRequestHeaders().getFirst(METHOD)));
        exchange.getRequestHeaders().put(Headers.HOST, exchange.getRequestHeaders().getFirst(AUTHORITY));
        if (!Connectors.areRequestHeadersValid(exchange.getRequestHeaders())) {
            UndertowLogger.REQUEST_IO_LOGGER.debugf("Invalid headers in HTTP/2 request, closing connection. Remote peer %s", (Object)connection.getPeerAddress());
            channel.sendGoAway(1);
            return;
        }
        String path = exchange.getRequestHeaders().getFirst(PATH);
        if (path == null || path.isEmpty()) {
            UndertowLogger.REQUEST_IO_LOGGER.debugf("No :path header sent in HTTP/2 request, closing connection. Remote peer %s", (Object)connection.getPeerAddress());
            channel.sendGoAway(1);
            return;
        }
        if (this.recordRequestStartTime) {
            Connectors.setRequestStartTime(exchange);
        }
        if ((session = channel.getSslSession()) != null) {
            connection.setSslSessionInfo(new Http2SslSessionInfo(channel));
        }
        dataChannel.getResponseChannel().setCompletionListener(new ChannelListener<Http2DataStreamSinkChannel>(){

            @Override
            public void handleEvent(Http2DataStreamSinkChannel channel) {
                Connectors.terminateResponse(exchange);
            }
        });
        if (!dataChannel.isOpen()) {
            Connectors.terminateRequest(exchange);
        } else {
            dataChannel.setCompletionListener(new ChannelListener<Http2StreamSourceChannel>(){

                @Override
                public void handleEvent(Http2StreamSourceChannel channel) {
                    Connectors.terminateRequest(exchange);
                }
            });
        }
        if (this.connectorStatistics != null) {
            this.connectorStatistics.setup(exchange);
        }
        try {
            Connectors.setExchangeRequestPath(exchange, path, this.encoding, this.decode, this.allowEncodingSlash, this.decodeBuffer, this.maxParameters);
        }
        catch (ParameterLimitException e) {
            UndertowLogger.REQUEST_IO_LOGGER.debug("Failed to set request path", e);
            exchange.setStatusCode(400);
            exchange.endExchange();
            return;
        }
        exchange.getRequestHeaders().remove(AUTHORITY);
        exchange.getRequestHeaders().remove(PATH);
        exchange.getRequestHeaders().remove(SCHEME);
        exchange.getRequestHeaders().remove(METHOD);
        Connectors.executeRootHandler(this.rootHandler, exchange);
    }

    void handleInitialRequest(HttpServerExchange initial, Http2Channel channel, byte[] data) {
        Http2HeadersStreamSinkChannel sink = channel.createInitialUpgradeResponseStream();
        Http2ServerConnection connection = new Http2ServerConnection(channel, sink, this.undertowOptions, this.bufferSize, this.rootHandler);
        HeaderMap requestHeaders = new HeaderMap();
        for (HeaderValues hv : initial.getRequestHeaders()) {
            requestHeaders.putAll(hv.getHeaderName(), hv);
        }
        final HttpServerExchange exchange = new HttpServerExchange(connection, requestHeaders, sink.getHeaders(), this.maxEntitySize);
        if (initial.getAttachment(HttpAttachments.REQUEST_TRAILERS) != null) {
            exchange.putAttachment(HttpAttachments.REQUEST_TRAILERS, initial.getAttachment(HttpAttachments.REQUEST_TRAILERS));
        }
        Connectors.setRequestStartTime(initial, exchange);
        connection.setExchange(exchange);
        exchange.setRequestScheme(initial.getRequestScheme());
        exchange.setProtocol(initial.getProtocol());
        exchange.setRequestMethod(initial.getRequestMethod());
        exchange.setQueryString(initial.getQueryString());
        if (data != null) {
            Connectors.ungetRequestBytes(exchange, new ImmediatePooledByteBuffer(ByteBuffer.wrap(data)));
        } else {
            Connectors.terminateRequest(exchange);
        }
        String uri = exchange.getQueryString().isEmpty() ? initial.getRequestURI() : initial.getRequestURI() + '?' + exchange.getQueryString();
        try {
            Connectors.setExchangeRequestPath(exchange, uri, this.encoding, this.decode, this.allowEncodingSlash, this.decodeBuffer, this.maxParameters);
        }
        catch (ParameterLimitException e) {
            exchange.setStatusCode(400);
            exchange.endExchange();
            return;
        }
        sink.setTrailersProducer(new Http2DataStreamSinkChannel.TrailersProducer(){

            @Override
            public HeaderMap getTrailers() {
                return exchange.getAttachment(HttpAttachments.RESPONSE_TRAILERS);
            }
        });
        SSLSession session = channel.getSslSession();
        if (session != null) {
            connection.setSslSessionInfo(new Http2SslSessionInfo(channel));
        }
        sink.setCompletionListener(new ChannelListener<Http2DataStreamSinkChannel>(){

            @Override
            public void handleEvent(Http2DataStreamSinkChannel channel) {
                Connectors.terminateResponse(exchange);
            }
        });
        Connectors.executeRootHandler(this.rootHandler, exchange);
    }

    private boolean checkRequestHeaders(HeaderMap headers) {
        if (headers.count(METHOD) != 1 || headers.contains(Headers.CONNECTION)) {
            return false;
        }
        if (headers.get(METHOD).contains("CONNECT") ? headers.contains(SCHEME) || headers.contains(PATH) || headers.count(AUTHORITY) != 1 : headers.count(SCHEME) != 1 || headers.count(PATH) != 1) {
            return false;
        }
        if (headers.contains(Headers.TE)) {
            for (String value : headers.get(Headers.TE)) {
                if (value.equals("trailers")) continue;
                return false;
            }
        }
        return true;
    }
}

