/*
 * Decompiled with CFR 0.152.
 */
package javax.resource.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EventObject;
import javax.resource.spi.ManagedConnection;

public class ConnectionEvent
extends EventObject {
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final int ID_IDX = 0;
    private static final int EXCEPTION_IDX = 1;
    private static final int CONN_HANDLE_IDX = 2;
    public static final int CONNECTION_CLOSED = 1;
    public static final int LOCAL_TRANSACTION_STARTED = 2;
    public static final int LOCAL_TRANSACTION_COMMITTED = 3;
    public static final int LOCAL_TRANSACTION_ROLLEDBACK = 4;
    public static final int CONNECTION_ERROR_OCCURRED = 5;
    private Exception e;
    protected int id;
    private Object connectionHandle;

    public ConnectionEvent(ManagedConnection source, int eid) {
        super(source);
        this.id = eid;
    }

    public ConnectionEvent(ManagedConnection source, int eid, Exception exception) {
        super(source);
        this.e = exception;
        this.id = eid;
    }

    public Object getConnectionHandle() {
        return this.connectionHandle;
    }

    public void setConnectionHandle(Object connectionHandle) {
        this.connectionHandle = connectionHandle;
    }

    public Exception getException() {
        return this.e;
    }

    public int getId() {
        return this.id;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        String name = serialPersistentFields[0].getName();
        this.id = fields.get(name, 5);
        name = serialPersistentFields[1].getName();
        this.e = (Exception)fields.get(name, null);
        name = serialPersistentFields[2].getName();
        this.connectionHandle = fields.get(name, null);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField fields = oos.putFields();
        String name = serialPersistentFields[0].getName();
        fields.put(name, this.id);
        name = serialPersistentFields[1].getName();
        fields.put(name, this.e);
        name = serialPersistentFields[2].getName();
        fields.put(name, this.connectionHandle);
        oos.writeFields();
    }

    static {
        Boolean legacy = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Boolean run() {
                try {
                    if (System.getProperty("org.jboss.j2ee.LegacySerialization") != null) {
                        return Boolean.TRUE;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return Boolean.FALSE;
            }
        });
        if (Boolean.TRUE.equals(legacy)) {
            serialVersionUID = 2776168349823367611L;
            serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("id", Integer.TYPE), new ObjectStreamField("e", Exception.class), new ObjectStreamField("connectionHandle", Object.class)};
        } else {
            serialVersionUID = 5611772461379563249L;
            serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("id", Integer.TYPE), new ObjectStreamField("exception", Exception.class), new ObjectStreamField("connectionHandle", Object.class)};
        }
    }
}

