/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.MessagePacket;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;

public class SessionReceiveMessage
extends MessagePacket {
    private long consumerID;
    private int deliveryCount;

    public SessionReceiveMessage(long consumerID, MessageInternal message, int deliveryCount) {
        super((byte)75, message);
        this.consumerID = consumerID;
        this.deliveryCount = deliveryCount;
    }

    public SessionReceiveMessage(MessageInternal message) {
        super((byte)75, message);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    @Override
    public ActiveMQBuffer encode(RemotingConnection connection) {
        ActiveMQBuffer buffer = this.message.getEncodedBuffer();
        ActiveMQBuffer bufferWrite = connection.createTransportBuffer(buffer.writerIndex() + 8 + 4);
        bufferWrite.writeBytes(buffer, 0, buffer.capacity());
        bufferWrite.setIndex(buffer.readerIndex(), buffer.writerIndex());
        if (bufferWrite.writerIndex() != this.message.getEndOfMessagePosition()) {
            throw new IllegalStateException("Wrong encode position");
        }
        bufferWrite.writeLong(this.consumerID);
        bufferWrite.writeInt(this.deliveryCount);
        this.size = bufferWrite.writerIndex();
        int len = this.size - 4;
        bufferWrite.setInt(0, len);
        bufferWrite.setByte(4, this.getType());
        bufferWrite.setLong(5, this.channelID);
        bufferWrite.setIndex(0, this.size);
        return bufferWrite;
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        this.channelID = buffer.readLong();
        this.message.decodeFromBuffer(buffer);
        this.consumerID = buffer.readLong();
        this.deliveryCount = buffer.readInt();
        this.size = buffer.readerIndex();
        buffer.setIndex(17, this.message.getEndOfBodyPosition());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.consumerID ^ this.consumerID >>> 32);
        result = 31 * result + this.deliveryCount;
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", consumerID=" + this.consumerID);
        buff.append(", deliveryCount=" + this.deliveryCount);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionReceiveMessage)) {
            return false;
        }
        SessionReceiveMessage other = (SessionReceiveMessage)obj;
        if (this.consumerID != other.consumerID) {
            return false;
        }
        return this.deliveryCount == other.deliveryCount;
    }
}

