/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.runnables;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.utils.runnables.AtomicRunnableWithDelegate;

public abstract class AtomicRunnable
implements Runnable {
    private volatile int ran;
    private static final AtomicIntegerFieldUpdater<AtomicRunnable> RAN_UPDATE = AtomicIntegerFieldUpdater.newUpdater(AtomicRunnable.class, "ran");

    public static Runnable checkAtomic(Runnable run) {
        if (run instanceof AtomicRunnable) {
            return run;
        }
        return new AtomicRunnableWithDelegate(run);
    }

    @Override
    public void run() {
        if (RAN_UPDATE.compareAndSet(this, 0, 1)) {
            this.atomicRun();
        }
    }

    public abstract void atomicRun();
}

