/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz.jacc;

import java.security.Permission;
import java.security.ProtectionDomain;
import javax.security.jacc.PolicyContextException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ELY", length=5)
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = Logger.getMessageLogger(ElytronMessages.class, "org.wildfly.security");

    @Message(id=3018, value="Cannot add permissions to a read-only permission collection")
    public SecurityException readOnlyPermissionCollection();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8500, value="Failed to check permissions for protection domain [%s] and permission [%s].")
    public void authzFailedToCheckPermission(ProtectionDomain var1, Permission var2, @Cause Throwable var3);

    @Message(id=8501, value="Invalid state [%s] for operation.")
    public UnsupportedOperationException authzInvalidStateForOperation(String var1);

    @Message(id=8502, value="Can't link policy configuration [%s] to itself.")
    public IllegalArgumentException authzLinkSamePolicyConfiguration(String var1);

    @Message(id=8503, value="ContextID not set. Check if the context id was set using PolicyContext.setContextID.")
    public IllegalStateException authzContextIdentifierNotSet();

    @Message(id=8504, value="Invalid policy context identifier [%s].")
    public IllegalArgumentException authzInvalidPolicyContextIdentifier(String var1);

    @Message(id=8505, value="Could not obtain PolicyConfiguration for contextID [%s].")
    public PolicyContextException authzUnableToObtainPolicyConfiguration(String var1, @Cause Throwable var2);

    @Message(id=8506, value="Policy configuration with contextID [%s] is not in service state.")
    public IllegalStateException authzPolicyConfigurationNotInService(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=8508, value="Could not obtain authorized identity.")
    public void authzCouldNotObtainSecurityIdentity(@Cause Throwable var1);
}

