/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.Closeable;
import java.io.DataInput;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.blocks.cs.BaseServer;
import org.jgroups.blocks.cs.Client;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.ConnectionListener;
import org.jgroups.blocks.cs.NioClient;
import org.jgroups.blocks.cs.ReceiverAdapter;
import org.jgroups.blocks.cs.TcpClient;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.PingData;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.GossipType;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public class RouterStub
extends ReceiverAdapter
implements Comparable<RouterStub>,
ConnectionListener {
    protected BaseServer client;
    protected final IpAddress local;
    protected final IpAddress remote;
    protected final boolean use_nio;
    protected StubReceiver receiver;
    protected CloseListener close_listener;
    protected static final Log log = LogFactory.getLog(RouterStub.class);
    protected int sock_conn_timeout = 3000;
    protected boolean tcp_nodelay = true;
    protected final Map<String, List<MembersNotification>> get_members_map = new HashMap<String, List<MembersNotification>>();

    public RouterStub(InetAddress bind_addr, int bind_port, InetAddress router_host, int router_port, boolean use_nio, CloseListener l) {
        this.local = new IpAddress(bind_addr, bind_port);
        this.remote = new IpAddress(router_host, router_port);
        this.use_nio = use_nio;
        this.close_listener = l;
        this.client = use_nio ? new NioClient(bind_addr, bind_port, router_host, router_port) : new TcpClient(bind_addr, bind_port, router_host, router_port);
        this.client.addConnectionListener(this);
        this.client.receiver(this);
        this.client.socketConnectionTimeout(this.sock_conn_timeout).tcpNodelay(this.tcp_nodelay);
    }

    public RouterStub(IpAddress local, IpAddress remote, boolean use_nio, CloseListener l) {
        this.local = local;
        this.remote = remote;
        this.use_nio = use_nio;
        this.close_listener = l;
        this.client = use_nio ? new NioClient(local, remote) : new TcpClient(local, remote);
        this.client.receiver(this);
        this.client.addConnectionListener(this);
        this.client.socketConnectionTimeout(this.sock_conn_timeout).tcpNodelay(this.tcp_nodelay);
    }

    public IpAddress local() {
        return this.local;
    }

    public IpAddress remote() {
        return this.remote;
    }

    public RouterStub receiver(StubReceiver r) {
        this.receiver = r;
        return this;
    }

    public StubReceiver receiver() {
        return this.receiver;
    }

    public boolean tcpNoDelay() {
        return this.tcp_nodelay;
    }

    public RouterStub tcpNoDelay(boolean tcp_nodelay) {
        this.tcp_nodelay = tcp_nodelay;
        return this;
    }

    public CloseListener connectionListener() {
        return this.close_listener;
    }

    public RouterStub connectionListener(CloseListener l) {
        this.close_listener = l;
        return this;
    }

    public int socketConnectionTimeout() {
        return this.sock_conn_timeout;
    }

    public RouterStub socketConnectionTimeout(int timeout) {
        this.sock_conn_timeout = timeout;
        return this;
    }

    public boolean useNio() {
        return this.use_nio;
    }

    public IpAddress gossipRouterAddress() {
        return this.remote;
    }

    public boolean isConnected() {
        return this.client != null && ((Client)((Object)this.client)).isConnected();
    }

    public RouterStub set(String attr, Object val) {
        switch (attr) {
            case "tcp_nodelay": {
                this.tcpNoDelay((Boolean)val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Attribute " + attr + " unknown");
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String group, Address addr, String logical_name, PhysicalAddress phys_addr) throws Exception {
        RouterStub routerStub = this;
        synchronized (routerStub) {
            this._doConnect();
        }
        try {
            this.writeRequest(new GossipData(GossipType.REGISTER, group, addr, logical_name, phys_addr));
        }
        catch (Exception ex) {
            throw new Exception(String.format("connection to %s failed: %s", group, ex));
        }
    }

    public synchronized void connect() throws Exception {
        this._doConnect();
    }

    protected void _doConnect() throws Exception {
        this.client.start();
    }

    public void disconnect(String group, Address addr) throws Exception {
        this.writeRequest(new GossipData(GossipType.UNREGISTER, group, addr));
    }

    public void destroy() {
        Util.close((Closeable)this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMembers(String group, MembersNotification callback) throws Exception {
        if (callback == null) {
            return;
        }
        Map<String, List<MembersNotification>> map = this.get_members_map;
        synchronized (map) {
            List<MembersNotification> set = this.get_members_map.get(group);
            if (set == null) {
                set = new ArrayList<MembersNotification>();
                this.get_members_map.put(group, set);
            }
            set.add(callback);
        }
        try {
            this.writeRequest(new GossipData(GossipType.GET_MBRS, group, null));
        }
        catch (Exception ex) {
            this.removeResponse(group, callback);
            throw new Exception(String.format("connection to %s broken. Could not send %s request: %s", new Object[]{this.gossipRouterAddress(), GossipType.GET_MBRS, ex}));
        }
    }

    public void sendToAllMembers(String group, Address sender, byte[] data, int offset, int length) throws Exception {
        this.sendToMember(group, null, sender, data, offset, length);
    }

    public void sendToMember(String group, Address dest, Address sender, byte[] data, int offset, int length) throws Exception {
        try {
            this.writeRequest(new GossipData(GossipType.MESSAGE, group, dest, data, offset, length).setSender(sender));
        }
        catch (Exception ex) {
            throw new Exception(String.format("connection to %s broken. Could not send message to %s: %s", this.gossipRouterAddress(), dest, ex));
        }
    }

    @Override
    public void receive(Address sender, byte[] buf, int offset, int length) {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buf, offset, length);
        GossipData data = new GossipData();
        try {
            data.readFrom(in);
            switch (data.getType()) {
                case MESSAGE: 
                case SUSPECT: {
                    if (this.receiver == null) break;
                    this.receiver.receive(data);
                    break;
                }
                case GET_MBRS_RSP: {
                    this.notifyResponse(data.getGroup(), data.getPingData());
                }
            }
        }
        catch (Exception ex) {
            log.error(Util.getMessage("FailedReadingData"), ex);
        }
    }

    @Override
    public void receive(Address sender, ByteBuffer buf) {
        Util.bufferToArray(sender, buf, this);
    }

    @Override
    public void receive(Address sender, DataInput in) throws Exception {
        GossipData data = new GossipData();
        data.readFrom(in);
        switch (data.getType()) {
            case MESSAGE: 
            case SUSPECT: {
                if (this.receiver == null) break;
                this.receiver.receive(data);
                break;
            }
            case GET_MBRS_RSP: {
                this.notifyResponse(data.getGroup(), data.getPingData());
            }
        }
    }

    @Override
    public void connectionClosed(Connection conn, String reason) {
        if (this.close_listener != null) {
            this.close_listener.closed(this);
        }
    }

    @Override
    public void connectionEstablished(Connection conn) {
    }

    @Override
    public int compareTo(RouterStub o) {
        return this.remote.compareTo(o.remote);
    }

    public int hashCode() {
        return this.remote.hashCode();
    }

    public boolean equals(Object obj) {
        return this.compareTo((RouterStub)obj) == 0;
    }

    public String toString() {
        return String.format("RouterStub[localsocket=%s, router_host=%s]", this.client.localAddress(), this.remote);
    }

    protected synchronized void writeRequest(GossipData req) throws Exception {
        int size = req.serializedSize();
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(size + 5);
        req.writeTo(out);
        this.client.send(this.remote, out.buffer(), 0, out.position());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeResponse(String group, MembersNotification notif) {
        Map<String, List<MembersNotification>> map = this.get_members_map;
        synchronized (map) {
            List<MembersNotification> set = this.get_members_map.get(group);
            if (set == null || set.isEmpty()) {
                this.get_members_map.remove(group);
                return;
            }
            if (set.remove(notif) && set.isEmpty()) {
                this.get_members_map.remove(group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyResponse(String group, List<PingData> list) {
        if (group == null) {
            return;
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        Map<String, List<MembersNotification>> map = this.get_members_map;
        synchronized (map) {
            List<MembersNotification> set = this.get_members_map.get(group);
            while (set != null && !set.isEmpty()) {
                try {
                    MembersNotification rsp = set.remove(0);
                    rsp.members(list);
                }
                catch (Throwable t) {
                    log.error("failed notifying %s: %s", group, t);
                }
            }
            this.get_members_map.remove(group);
        }
    }

    public static interface CloseListener {
        public void closed(RouterStub var1);
    }

    public static interface MembersNotification {
        public void members(List<PingData> var1);
    }

    public static interface StubReceiver {
        public void receive(GossipData var1);
    }
}

