package org.jgroups.tests;

import org.jgroups.*;
import org.jgroups.protocols.*;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.Protocol;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla6 extends ReceiverAdapter implements ChannelListener {
    protected JChannel channel;

    void start(String name) throws Exception {
        Protocol[] prot_stack = {
          new UDP(),
          new PING()
            .staggerTimeout(1500)
            .setValue("num_discovery_runs", 10)
            .setValue("async_discovery", true)
            .setValue("async_discovery_use_separate_thread_per_request", true)
            .setValue("discovery_rsp_expiry_time", 5000),
          new MERGE3(),
          new FD_SOCK(),
          new FD_ALL(),
          new VERIFY_SUSPECT(),
          new BARRIER(),
          new NAKACK2(),
          new UNICAST3(),
          new STABLE(),
          new GMS(),
          new UFC(),
          new MFC(),
          new FRAG2()};

        channel = new JChannel(prot_stack).setReceiver(this).addChannelListener(this).setName(name);
        channel.setDiscardOwnMessages(true);
        channel.connect("RFID Cluster");
        System.out.println("-- joined cluster");
    }

    public void receive(Message msg) {
        System.out.printf("-- msg from %s: %s\n", msg.src(), msg.getObject());
    }

    public void viewAccepted(View view) {
        System.out.printf("-- view: %s\n", view);
    }

    public static void main(String[] args) throws Exception {
        new bla6().start(args[0]);
    }

    public void channelConnected(JChannel channel) {

    }

    public void channelDisconnected(JChannel channel) {

    }

    public void channelClosed(JChannel channel) {

    }
}
