package org.jgroups.tests;

import org.jgroups.*;
import org.jgroups.util.Util;

import java.io.*;
import java.util.LinkedList;
import java.util.List;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla6 extends ReceiverAdapter {
    JChannel channel;
    String user_name=System.getProperty("user.name", "n/a");
    final List<String> state=new LinkedList<>();

    public void viewAccepted(View new_view) {
           System.out.println("** view: " + new_view);
       }

       public void receive(Message msg) {
           String line=msg.getSrc() + ": " + msg.getObject();
           System.out.println(line);
           synchronized(state) {
               state.add(line);
           }
       }

       public void getState(OutputStream output) throws Exception {
           synchronized(state) {
               Util.objectToStream(state, new DataOutputStream(output));
           }
       }

       public void setState(InputStream input) throws Exception {
           List<String> list=Util.objectFromStream(new DataInputStream(input));
           synchronized(state) {
               state.clear();
               state.addAll(list);
           }
           System.out.println("received state (" + list.size() + " messages in chat history):");
           list.forEach(System.out::println);
       }


       private void start() throws Exception {
           channel=new JChannel().setReceiver(this);
           channel.connect("ChatCluster");
           channel.getState(null, 10000);
           eventLoop();
           channel.close();
       }

       private void eventLoop() {
           BufferedReader in=new BufferedReader(new InputStreamReader(System.in));
           while(true) {
               try {
                   System.out.print("> "); System.out.flush();
                   String line=in.readLine().toLowerCase();
                   if(line.startsWith("quit") || line.startsWith("exit")) {
                       break;
                   }
                   line="[" + user_name + "] " + line;
                   Message msg=null; // new BytesMessage(null, line);
                   channel.send(msg);
               }
               catch(Exception e) {
               }
           }
       }


    public static void main(String[] args) throws Exception {
        new bla6().start();
    }




}
