package org.jgroups.tests;

import java.io.IOException;
import java.net.*;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla2 {

    public static void main(String[] args) throws Exception {




        NetworkInterface ni = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());

        DatagramChannel dc = DatagramChannel.open(StandardProtocolFamily.INET)
          .setOption(StandardSocketOptions.SO_REUSEADDR, true)
          .bind(new InetSocketAddress(5000));
          // .setOption(StandardSocketOptions.IP_MULTICAST_IF, ni);

        InetAddress group = InetAddress.getByName("225.4.5.6");

        MembershipKey key = dc.join(group, ni);


        System.out.println("key = " + key);



       /*
        InetAddress group=InetAddress.getByName("239.5.5.5");
        InetAddress bind_addr=InetAddress.getLocalHost();


        MulticastSocket sock=new MulticastSocket(new InetSocketAddress(6789));
        sock.setInterface(bind_addr);
        sock.joinGroup(group);



        Reader reader=new Reader(sock);
        Thread t=new Thread(reader);
        t.start();

        while(true) {
            String line=Util.readStringFromStdin("> ");
            if(line == null || line.isEmpty())
                continue;
            byte[] buf=line.getBytes();
            DatagramPacket packet=new DatagramPacket(buf, 0, buf.length, group, 6789);
            sock.send(packet);
        }*/
    }


    protected static final class Reader implements Runnable {
        protected final MulticastSocket s;

        public Reader(MulticastSocket s) {
            this.s=s;
        }

        public void run() {
            byte[] buf=new byte[0xff];
            while(!s.isClosed()) {
                DatagramPacket p=new DatagramPacket(buf, 0, buf.length);
                try {
                    s.receive(p);
                    String line=new String(p.getData(), p.getOffset(), p.getLength());
                    System.out.printf(">> %s\n", line);
                }
                catch(IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }


}
