/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jboss.marshalling.ByteOutput;
import org.wildfly.common.Assert;
import org.wildfly.httpclient.common.HttpClientMessages;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.channels.StreamSinkChannel;

class WildflyClientOutputStream
extends OutputStream
implements ByteOutput {
    private final Object lock = new Object();
    private PooledByteBuffer pooledBuffer;
    private IOException ioException;
    private final StreamSinkChannel channel;
    private final ByteBufferPool bufferPool;
    private int state;
    private static final int FLAG_CLOSED = 1;
    private static final int FLAG_WRITING = 2;
    private static final int FLAG_DONE = 4;
    private final ChannelListener<StreamSinkChannel> channelListener = new ChannelListener<StreamSinkChannel>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(StreamSinkChannel streamSinkChannel) {
            Object object = WildflyClientOutputStream.this.lock;
            synchronized (object) {
                if (Bits.anyAreClear(WildflyClientOutputStream.this.state, 2)) {
                    return;
                }
                try {
                    boolean closed = Bits.anyAreSet(WildflyClientOutputStream.this.state, 1);
                    if (WildflyClientOutputStream.this.pooledBuffer != null) {
                        WildflyClientOutputStream.this.pooledBuffer.getBuffer().flip();
                    }
                    if (closed && (WildflyClientOutputStream.this.pooledBuffer == null || !WildflyClientOutputStream.this.pooledBuffer.getBuffer().hasRemaining())) {
                        if (WildflyClientOutputStream.this.pooledBuffer != null) {
                            WildflyClientOutputStream.this.pooledBuffer.close();
                            WildflyClientOutputStream.this.pooledBuffer = null;
                        }
                        if (streamSinkChannel.flush()) {
                            WildflyClientOutputStream.this.state = WildflyClientOutputStream.this.state | 4;
                            WildflyClientOutputStream.this.state = WildflyClientOutputStream.this.state & 0xFFFFFFFD;
                            WildflyClientOutputStream.this.lock.notifyAll();
                            streamSinkChannel.shutdownWrites();
                        }
                    } else {
                        while (WildflyClientOutputStream.this.pooledBuffer.getBuffer().hasRemaining()) {
                            int res = closed ? streamSinkChannel.writeFinal(WildflyClientOutputStream.this.pooledBuffer.getBuffer()) : streamSinkChannel.write(WildflyClientOutputStream.this.pooledBuffer.getBuffer());
                            if (res != 0) continue;
                            return;
                        }
                        WildflyClientOutputStream.this.lock.notifyAll();
                        streamSinkChannel.suspendWrites();
                        WildflyClientOutputStream.this.state = WildflyClientOutputStream.this.state & 0xFFFFFFFD;
                        WildflyClientOutputStream.this.pooledBuffer.close();
                        WildflyClientOutputStream.this.pooledBuffer = null;
                        if (closed && streamSinkChannel.flush()) {
                            WildflyClientOutputStream.this.state = WildflyClientOutputStream.this.state | 4;
                        }
                    }
                }
                catch (IOException e) {
                    if (WildflyClientOutputStream.this.pooledBuffer != null) {
                        WildflyClientOutputStream.this.pooledBuffer.close();
                        WildflyClientOutputStream.this.pooledBuffer = null;
                    }
                    WildflyClientOutputStream.this.state = WildflyClientOutputStream.this.state & 0xFFFFFFFD;
                    WildflyClientOutputStream.this.ioException = e;
                    WildflyClientOutputStream.this.lock.notifyAll();
                }
            }
        }
    };

    WildflyClientOutputStream(StreamSinkChannel channel, ByteBufferPool byteBufferPool) {
        this.channel = channel;
        this.bufferPool = byteBufferPool;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 1) {
            return;
        }
        if (Thread.currentThread() == this.channel.getIoThread()) {
            throw HttpClientMessages.MESSAGES.blockingIoFromIOThread();
        }
        if (Bits.anyAreSet(this.state, 1)) {
            throw HttpClientMessages.MESSAGES.streamIsClosed();
        }
        int currentOff = off;
        int currentLen = len;
        Object object = this.lock;
        synchronized (object) {
            ByteBuffer buffer;
            while (true) {
                if (Bits.anyAreSet(this.state, 2) && this.ioException == null) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException(e.getMessage());
                    }
                }
                if (this.ioException != null) {
                    throw new IOException(this.ioException);
                }
                buffer = this.buffer();
                if (buffer.remaining() >= currentLen) break;
                int put = buffer.remaining();
                buffer.put(b, currentOff, buffer.remaining());
                currentOff += put;
                currentLen -= put;
                this.runWriteTask();
            }
            buffer.put(b, currentOff, currentLen);
            if (buffer.remaining() == 0) {
                this.runWriteTask();
            }
            return;
        }
    }

    private void runWriteTask() {
        Assert.assertHoldsLock(this.lock);
        this.state |= 2;
        this.channel.getWriteSetter().set(this.channelListener);
        this.channel.wakeupWrites();
    }

    @Override
    public void flush() throws IOException {
        if (Bits.anyAreSet(this.state, 1)) {
            throw HttpClientMessages.MESSAGES.streamIsClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.ioException != null) {
                throw new IOException(this.ioException);
            }
            if (Bits.anyAreSet(this.state, 1)) {
                return;
            }
            this.state |= 1;
            this.runWriteTask();
            while (Bits.allAreClear(this.state, 4) && this.ioException != null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.getMessage());
                }
            }
            if (this.ioException != null) {
                throw new IOException(this.ioException);
            }
        }
    }

    private ByteBuffer buffer() {
        PooledByteBuffer buffer = this.pooledBuffer;
        if (buffer != null) {
            return buffer.getBuffer();
        }
        this.pooledBuffer = this.bufferPool.allocate();
        return this.pooledBuffer.getBuffer();
    }
}

