/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Inet6Address;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.ejb.EJBException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBMethodLocator;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.UserTransactionID;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.ejb.client.annotation.CompressionHint;
import org.jboss.ejb.protocol.remote.NoFlushByteOutput;
import org.jboss.ejb.protocol.remote.PackedInteger;
import org.jboss.ejb.protocol.remote.ProtocolObjectResolver;
import org.jboss.ejb.protocol.remote.ProtocolV1ClassTable;
import org.jboss.ejb.protocol.remote.ProtocolV1ObjectResolver;
import org.jboss.ejb.protocol.remote.ProtocolV1ObjectTable;
import org.jboss.ejb.protocol.remote.ProtocolV3ObjectResolver;
import org.jboss.ejb.protocol.remote.ProtocolV3ObjectTable;
import org.jboss.ejb.protocol.remote.TCCLUtils;
import org.jboss.ejb.protocol.remote.WrapperMessageOutputStream;
import org.jboss.ejb.server.Association;
import org.jboss.ejb.server.CancelHandle;
import org.jboss.ejb.server.ClusterTopologyListener;
import org.jboss.ejb.server.InvocationRequest;
import org.jboss.ejb.server.ListenerHandle;
import org.jboss.ejb.server.ModuleAvailabilityListener;
import org.jboss.ejb.server.Request;
import org.jboss.ejb.server.SessionOpenRequest;
import org.jboss.marshalling.AbstractClassResolver;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.river.RiverMarshallerFactory;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3._private.IntIndexHashMap;
import org.jboss.remoting3.util.MessageTracker;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionServer;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;
import org.xnio.IoUtils;

final class EJBServerChannel {
    private static final char METHOD_PARAM_TYPE_SEPARATOR = ',';
    private final RemotingTransactionServer transactionServer;
    private final Channel channel;
    private final int version;
    private final MessageTracker messageTracker;
    private final MarshallerFactory marshallerFactory;
    private final MarshallingConfiguration configuration;
    private final IntIndexHashMap<InProgress> invocations = new IntIndexHashMap<InProgress>(InProgress::getInvId);
    private final Function<String, Boolean> classResolverFilter;

    EJBServerChannel(RemotingTransactionServer transactionServer, Channel channel, int version, MessageTracker messageTracker, Function<String, Boolean> classResolverFilter) {
        this.transactionServer = transactionServer;
        this.channel = channel;
        this.version = version;
        this.messageTracker = messageTracker;
        MarshallingConfiguration configuration = new MarshallingConfiguration();
        if (version < 3) {
            configuration.setClassTable(ProtocolV1ClassTable.INSTANCE);
            configuration.setObjectTable(ProtocolV1ObjectTable.INSTANCE);
            configuration.setObjectResolver(new ProtocolV1ObjectResolver(channel.getConnection(), true));
            configuration.setVersion(2);
        } else {
            configuration.setObjectTable(ProtocolV3ObjectTable.INSTANCE);
            configuration.setObjectResolver(new ProtocolV3ObjectResolver(channel.getConnection(), true));
            configuration.setVersion(4);
        }
        this.marshallerFactory = new RiverMarshallerFactory();
        this.configuration = configuration;
        this.classResolverFilter = classResolverFilter;
    }

    Channel.Receiver getReceiver(Association association, ListenerHandle handle1, ListenerHandle handle2) {
        return new ReceiverImpl(association, handle1, handle2);
    }

    ClusterTopologyListener createTopologyListener() {
        return new ClusterTopologyWriter();
    }

    ModuleAvailabilityListener createModuleListener() {
        return new ModuleAvailabilityWriter();
    }

    ExceptionSupplier<ImportResult<?>, SystemException> readTransaction(DataInput input) throws IOException {
        int type = input.readUnsignedByte();
        if (type == 0) {
            return null;
        }
        if (type == 1) {
            int id = input.readInt();
            int timeout = PackedInteger.readPackedInteger(input);
            return () -> new ImportResult<LocalTransaction>(this.transactionServer.getOrBeginTransaction(id, timeout), SubordinateTransactionControl.EMPTY, false);
        }
        if (type == 2) {
            int fmt = PackedInteger.readPackedInteger(input);
            byte[] gtid = new byte[input.readUnsignedByte()];
            input.readFully(gtid);
            byte[] bq = new byte[input.readUnsignedByte()];
            input.readFully(bq);
            int timeout = PackedInteger.readPackedInteger(input);
            return () -> {
                try {
                    return this.transactionServer.getTransactionService().getTransactionContext().findOrImportTransaction(new SimpleXid(fmt, gtid, bq), timeout);
                }
                catch (XAException e) {
                    throw new SystemException(e.getMessage());
                }
            };
        }
        throw Logs.REMOTING.invalidTransactionType(type);
    }

    private void writeFailedResponse(int invId, Throwable e) {
        try (MessageOutputStream os = this.messageTracker.openMessageUninterruptibly();){
            os.writeByte(6);
            os.writeShort(invId);
            Marshaller marshaller = this.marshallerFactory.createMarshaller(this.configuration);
            marshaller.start(new NoFlushByteOutput(Marshalling.createByteOutput(os)));
            marshaller.writeObject(new RequestSendFailedException(e.getMessage() + "@" + this.channel.getConnection().getPeerURI(), e));
            marshaller.writeByte(0);
            marshaller.finish();
        }
        catch (IOException e2) {
            e2.addSuppressed(e);
            Logs.REMOTING.ioExceptionOnEJBResponseWrite(invId, this.channel, e2);
        }
    }

    private static Method findMethod(Class componentView, EJBMethodLocator ejbMethodLocator) {
        Method[] viewMethods;
        for (Method method : viewMethods = componentView.getMethods()) {
            Class<?>[] methodParamTypes;
            if (!method.getName().equals(ejbMethodLocator.getMethodName()) || (methodParamTypes = method.getParameterTypes()).length != ejbMethodLocator.getParameterCount()) continue;
            boolean found = true;
            for (int i = 0; i < methodParamTypes.length; ++i) {
                if (methodParamTypes[i].getName().equals(ejbMethodLocator.getParameterTypeName(i))) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return method;
        }
        return null;
    }

    class ReceiverImpl
    implements Channel.Receiver {
        private final Association association;
        private final ListenerHandle handle1;
        private final ListenerHandle handle2;

        ReceiverImpl(Association association, ListenerHandle handle1, ListenerHandle handle2) {
            this.association = association;
            this.handle1 = handle1;
            this.handle2 = handle2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleError(Channel channel, IOException error) {
            ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
            try {
                this.handle1.close();
                this.handle2.close();
            }
            finally {
                TCCLUtils.resetTCCL(oldCL);
            }
        }

        @Override
        public void handleEnd(Channel channel) {
            ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
            try {
                this.handle1.close();
                this.handle2.close();
            }
            finally {
                TCCLUtils.resetTCCL(oldCL);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Channel channel, MessageInputStream message) {
            channel.receiveMessage(this);
            ClassLoader oldCL = TCCLUtils.getAndSetSafeTCCL();
            try {
                int code = message.readUnsignedByte();
                switch (code) {
                    case 3: 
                    case 27: {
                        try (InputStream input = code == 27 ? new InflaterInputStream(message) : message;){
                            int verify;
                            if (code == 27 && (verify = input.read()) != 3) {
                                throw new RuntimeException();
                            }
                            int invId = input.read() << 8 | input.read();
                            try {
                                this.handleInvocationRequest(invId, input);
                                return;
                            }
                            catch (IOException | ClassNotFoundException e) {
                                EJBServerChannel.this.writeFailedResponse(invId, e);
                            }
                            return;
                        }
                    }
                    case 1: {
                        int invId = message.readUnsignedShort();
                        try {
                            this.handleSessionOpenRequest(invId, message);
                            return;
                        }
                        catch (IOException e) {
                            EJBServerChannel.this.writeFailedResponse(invId, e);
                            return;
                        }
                    }
                    case 4: {
                        int invId = message.readUnsignedShort();
                        try {
                            this.handleCancelRequest(invId, message);
                            return;
                        }
                        catch (IOException iOException) {
                            return;
                        }
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        int invId = message.readUnsignedShort();
                        try {
                            this.handleTxnRequest(code, invId, message);
                            return;
                        }
                        catch (IOException iOException) {
                            return;
                        }
                    }
                    case 25: {
                        int invId = message.readUnsignedShort();
                        try {
                            this.handleTxnRecoverRequest(invId, message);
                            return;
                        }
                        catch (IOException iOException) {
                            return;
                        }
                    }
                    default: {
                        Logs.REMOTING.invalidMessageReceived(code);
                        return;
                    }
                }
            }
            catch (IOException iOException) {
                return;
            }
            finally {
                IoUtils.safeClose((Closeable)message);
                TCCLUtils.resetTCCL(oldCL);
            }
        }

        private void writeTxnResponse(int invId, int flag) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(20);
                os.writeShort(invId);
                os.writeBoolean(true);
                PackedInteger.writePackedInteger(os, flag);
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnTransactionResponseWrite(invId, EJBServerChannel.this.channel, e);
            }
        }

        private void writeTxnResponse(int invId) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(20);
                os.writeShort(invId);
                os.writeBoolean(false);
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnTransactionResponseWrite(invId, EJBServerChannel.this.channel, e);
            }
        }

        private void handleTxnRequest(int code, int invId, MessageInputStream message) throws IOException {
            byte[] bytes = new byte[PackedInteger.readPackedInteger(message)];
            message.readFully(bytes);
            TransactionID transactionID = TransactionID.createTransactionID(bytes);
            if (transactionID instanceof XidTransactionID) {
                try {
                    SubordinateTransactionControl control = EJBServerChannel.this.transactionServer.getTransactionService().getTransactionContext().findOrImportTransaction(((XidTransactionID)transactionID).getXid(), 0).getControl();
                    switch (code) {
                        case 15: {
                            boolean opc = message.readBoolean();
                            control.commit(opc);
                            this.writeTxnResponse(invId);
                            break;
                        }
                        case 16: {
                            control.rollback();
                            this.writeTxnResponse(invId);
                            break;
                        }
                        case 17: {
                            int res = control.prepare();
                            this.writeTxnResponse(invId, res);
                            break;
                        }
                        case 18: {
                            control.forget();
                            this.writeTxnResponse(invId);
                            break;
                        }
                        case 19: {
                            control.beforeCompletion();
                            this.writeTxnResponse(invId);
                            break;
                        }
                        default: {
                            throw Assert.impossibleSwitchCase(code);
                        }
                    }
                }
                catch (XAException e) {
                    if (EJBServerChannel.this.version > 2 || e.errorCode != -4) {
                        EJBServerChannel.this.writeFailedResponse(invId, e);
                    }
                }
            } else if (transactionID instanceof UserTransactionID) {
                try {
                    LocalTransaction localTransaction = EJBServerChannel.this.transactionServer.removeTransaction(((UserTransactionID)transactionID).getId());
                    switch (code) {
                        case 15: {
                            message.readBoolean();
                            if (localTransaction != null) {
                                localTransaction.commit();
                            }
                            this.writeTxnResponse(invId);
                            break;
                        }
                        case 16: {
                            if (localTransaction != null) {
                                localTransaction.rollback();
                            }
                            this.writeTxnResponse(invId);
                            break;
                        }
                        case 17: 
                        case 18: 
                        case 19: {
                            EJBServerChannel.this.writeFailedResponse(invId, Logs.TXN.userTxNotSupportedByTxContext());
                            break;
                        }
                        default: {
                            throw Assert.impossibleSwitchCase(code);
                        }
                    }
                }
                catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
                    EJBServerChannel.this.writeFailedResponse(invId, e);
                }
                catch (Throwable t) {
                    EJBServerChannel.this.writeFailedResponse(invId, Logs.TXN.internalSystemErrorWithTx(t));
                }
            } else {
                throw Assert.unreachableCode();
            }
        }

        void handleTxnRecoverRequest(int invId, MessageInputStream message) throws IOException {
            Xid[] xids;
            String parentName = message.readUTF();
            int flags = message.readInt();
            try {
                xids = EJBServerChannel.this.transactionServer.getTransactionService().getTransactionContext().getRecoveryInterface().recover(flags, parentName);
            }
            catch (XAException e) {
                EJBServerChannel.this.writeFailedResponse(invId, e);
                return;
            }
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(26);
                os.writeShort(invId);
                PackedInteger.writePackedInteger(os, xids.length);
                Marshaller marshaller = EJBServerChannel.this.marshallerFactory.createMarshaller(EJBServerChannel.this.configuration);
                marshaller.start(new NoFlushByteOutput(Marshalling.createByteOutput(os)));
                for (Xid xid : xids) {
                    marshaller.writeObject(new XidTransactionID(xid));
                }
                marshaller.finish();
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnTransactionRecoveryResponseWrite(invId, EJBServerChannel.this.channel, e);
            }
        }

        void handleCancelRequest(int invId, MessageInputStream message) throws IOException {
            boolean cancelIfRunning = EJBServerChannel.this.version < 3 || message.readBoolean();
            InProgress inProgress = (InProgress)EJBServerChannel.this.invocations.get(invId);
            if (inProgress != null) {
                inProgress.cancel(cancelIfRunning);
            }
        }

        void handleSessionOpenRequest(int invId, MessageInputStream inputStream) throws IOException {
            ExceptionSupplier<ImportResult<?>, SystemException> transactionSupplier;
            int securityContext;
            String appName = inputStream.readUTF();
            String moduleName = inputStream.readUTF();
            String distName = inputStream.readUTF();
            String beanName = inputStream.readUTF();
            if (EJBServerChannel.this.version >= 3) {
                securityContext = inputStream.readInt();
                transactionSupplier = EJBServerChannel.this.readTransaction(inputStream);
            } else {
                securityContext = 0;
                transactionSupplier = null;
            }
            Connection connection = EJBServerChannel.this.channel.getConnection();
            EJBIdentifier identifier = new EJBIdentifier(appName, moduleName, beanName, distName);
            this.association.receiveSessionOpenRequest(new RemotingSessionOpenRequest(invId, identifier, transactionSupplier, connection.getLocalIdentity(securityContext)));
        }

        void handleInvocationRequest(int invId, InputStream input) throws IOException, ClassNotFoundException {
            SecurityIdentity identity;
            EJBMethodLocator methodLocator;
            EJBIdentifier identifier;
            Unmarshaller unmarshaller;
            MarshallingConfiguration configuration = EJBServerChannel.this.configuration.clone();
            ServerClassResolver classResolver = new ServerClassResolver(EJBServerChannel.this.classResolverFilter);
            configuration.setClassResolver(classResolver);
            Connection connection = EJBServerChannel.this.channel.getConnection();
            if (EJBServerChannel.this.version >= 3) {
                unmarshaller = EJBServerChannel.this.marshallerFactory.createUnmarshaller(configuration);
                unmarshaller.start(Marshalling.createByteInput(input));
                identifier = unmarshaller.readObject(EJBIdentifier.class);
                methodLocator = unmarshaller.readObject(EJBMethodLocator.class);
                int identityId = unmarshaller.readInt();
                identity = identityId == 0 ? connection.getLocalIdentity() : connection.getLocalIdentity(identityId);
            } else {
                assert (EJBServerChannel.this.version <= 2);
                DataInputStream data = new DataInputStream(input);
                String methodName = data.readUTF();
                String sigString = data.readUTF();
                unmarshaller = EJBServerChannel.this.marshallerFactory.createUnmarshaller(configuration);
                unmarshaller.start(Marshalling.createByteInput(data));
                String appName = unmarshaller.readObject(String.class);
                String moduleName = unmarshaller.readObject(String.class);
                String distinctName = unmarshaller.readObject(String.class);
                String beanName = unmarshaller.readObject(String.class);
                identifier = new EJBIdentifier(appName, moduleName, beanName, distinctName);
                String[] parameterTypeNames = sigString.isEmpty() ? new String[]{} : sigString.split(String.valueOf(','));
                methodLocator = new EJBMethodLocator(methodName, parameterTypeNames);
                identity = connection.getLocalIdentity();
            }
            RemotingInvocationRequest request = new RemotingInvocationRequest(invId, identifier, methodLocator, classResolver, unmarshaller, identity);
            InProgress value = new InProgress(request);
            EJBServerChannel.this.invocations.put(value);
            try {
                value.setCancelHandle(this.association.receiveInvocationRequest(request));
            }
            catch (Throwable t) {
                Logs.INVOCATION.unexpectedException(t);
                if (t instanceof Exception) {
                    request.writeException((Exception)t);
                }
                request.writeException(new EJBException(new RuntimeException(t)));
            }
        }
    }

    final class ClusterTopologyWriter
    implements ClusterTopologyListener {
        ClusterTopologyWriter() {
        }

        @Override
        public void clusterTopology(List<ClusterTopologyListener.ClusterInfo> clusterInfoList) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(21);
                PackedInteger.writePackedInteger(os, clusterInfoList.size());
                for (ClusterTopologyListener.ClusterInfo clusterInfo : clusterInfoList) {
                    os.writeUTF(clusterInfo.getClusterName());
                    List<ClusterTopologyListener.NodeInfo> nodeInfoList = clusterInfo.getNodeInfoList();
                    PackedInteger.writePackedInteger(os, nodeInfoList.size());
                    for (ClusterTopologyListener.NodeInfo nodeInfo : nodeInfoList) {
                        os.writeUTF(nodeInfo.getNodeName());
                        List<ClusterTopologyListener.MappingInfo> mappingInfoList = nodeInfo.getMappingInfoList();
                        PackedInteger.writePackedInteger(os, mappingInfoList.size());
                        for (ClusterTopologyListener.MappingInfo mappingInfo : mappingInfoList) {
                            boolean is6 = mappingInfo.getSourceAddress() instanceof Inet6Address;
                            if (is6) {
                                PackedInteger.writePackedInteger(os, mappingInfo.getNetmaskBits() << 1);
                            } else {
                                PackedInteger.writePackedInteger(os, mappingInfo.getNetmaskBits() << 1 | 1);
                            }
                            os.write(mappingInfo.getSourceAddress().getAddress());
                            os.writeUTF(mappingInfo.getDestinationAddress());
                            os.writeShort(mappingInfo.getDestinationPort());
                        }
                    }
                }
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnEJBClusterMessageWrite(EJBServerChannel.this.channel, e);
            }
        }

        @Override
        public void clusterRemoval(List<String> clusterNames) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(22);
                PackedInteger.writePackedInteger(os, clusterNames.size());
                for (String clusterName : clusterNames) {
                    os.writeUTF(clusterName);
                }
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnEJBClusterMessageWrite(EJBServerChannel.this.channel, e);
            }
        }

        @Override
        public void clusterNewNodesAdded(ClusterTopologyListener.ClusterInfo clusterInfo) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(23);
                PackedInteger.writePackedInteger(os, 1);
                os.writeUTF(clusterInfo.getClusterName());
                List<ClusterTopologyListener.NodeInfo> nodeInfoList = clusterInfo.getNodeInfoList();
                PackedInteger.writePackedInteger(os, nodeInfoList.size());
                for (ClusterTopologyListener.NodeInfo nodeInfo : nodeInfoList) {
                    os.writeUTF(nodeInfo.getNodeName());
                    List<ClusterTopologyListener.MappingInfo> mappingInfoList = nodeInfo.getMappingInfoList();
                    PackedInteger.writePackedInteger(os, mappingInfoList.size());
                    for (ClusterTopologyListener.MappingInfo mappingInfo : mappingInfoList) {
                        boolean is6 = mappingInfo.getSourceAddress() instanceof Inet6Address;
                        if (is6) {
                            PackedInteger.writePackedInteger(os, mappingInfo.getNetmaskBits() << 1);
                        } else {
                            PackedInteger.writePackedInteger(os, mappingInfo.getNetmaskBits() << 1 | 1);
                        }
                        os.write(mappingInfo.getSourceAddress().getAddress());
                        os.writeUTF(mappingInfo.getDestinationAddress());
                        os.writeShort(mappingInfo.getDestinationPort());
                    }
                }
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnEJBClusterMessageWrite(EJBServerChannel.this.channel, e);
            }
        }

        @Override
        public void clusterNodesRemoved(List<ClusterTopologyListener.ClusterRemovalInfo> clusterRemovalInfoList) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(24);
                PackedInteger.writePackedInteger(os, clusterRemovalInfoList.size());
                for (ClusterTopologyListener.ClusterRemovalInfo removalInfo : clusterRemovalInfoList) {
                    os.writeUTF(removalInfo.getClusterName());
                    List<String> nodeNamesList = removalInfo.getNodeNames();
                    PackedInteger.writePackedInteger(os, nodeNamesList.size());
                    for (String name : nodeNamesList) {
                        os.writeUTF(name);
                    }
                }
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnEJBClusterMessageWrite(EJBServerChannel.this.channel, e);
            }
        }

        @Override
        public Connection getConnection() {
            return EJBServerChannel.this.channel.getConnection();
        }
    }

    final class ModuleAvailabilityWriter
    implements ModuleAvailabilityListener {
        ModuleAvailabilityWriter() {
        }

        @Override
        public void moduleAvailable(List<EJBModuleIdentifier> modules) {
            this.doWrite(true, modules);
        }

        @Override
        public void moduleUnavailable(List<EJBModuleIdentifier> modules) {
            this.doWrite(false, modules);
        }

        private void doWrite(boolean available, List<EJBModuleIdentifier> modules) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(available ? 8 : 9);
                PackedInteger.writePackedInteger(os, modules.size());
                for (EJBModuleIdentifier module : modules) {
                    String appName = module.getAppName();
                    os.writeUTF(appName == null ? "" : appName);
                    String moduleName = module.getModuleName();
                    os.writeUTF(moduleName == null ? "" : moduleName);
                    String distinctName = module.getDistinctName();
                    os.writeUTF(distinctName == null ? "" : distinctName);
                }
            }
            catch (IOException e) {
                EJBServerChannel.this.channel.closeAsync();
                Logs.REMOTING.ioExceptionOnModuleAvailabilityWrite(EJBServerChannel.this.channel, e);
            }
        }
    }

    static final class ServerClassResolver
    extends AbstractClassResolver {
        private ClassLoader classLoader;
        private final Function<String, Boolean> classResolverFilter;

        ServerClassResolver(Function<String, Boolean> classResolverFilter) {
            super(true);
            this.classResolverFilter = classResolverFilter;
        }

        @Override
        public Class<?> resolveProxyClass(Unmarshaller unmarshaller, String[] interfaces) throws IOException, ClassNotFoundException {
            int length = interfaces.length;
            Class[] classes = new Class[length];
            for (int i = 0; i < length; ++i) {
                this.checkFilter(interfaces[i]);
                classes[i] = this.loadClass(interfaces[i]);
            }
            ClassLoader classLoader = length == 1 ? AccessController.doPrivileged(classes[0]::getClassLoader) : this.getClassLoader();
            return Proxy.getProxyClass(classLoader, classes);
        }

        @Override
        protected ClassLoader getClassLoader() {
            ClassLoader classLoader = this.classLoader;
            return classLoader == null ? this.getClass().getClassLoader() : classLoader;
        }

        @Override
        public Class<?> resolveClass(Unmarshaller unmarshaller, String name, long serialVersionUID) throws IOException, ClassNotFoundException {
            this.checkFilter(name);
            return super.resolveClass(unmarshaller, name, serialVersionUID);
        }

        void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        }

        private void checkFilter(String className) throws InvalidClassException {
            if (this.classResolverFilter != null && this.classResolverFilter.apply(className) != Boolean.TRUE) {
                throw Logs.REMOTING.cannotResolveFilteredClass(className);
            }
        }
    }

    static final class InProgress {
        private final RemotingInvocationRequest incomingInvocation;
        private CancelHandle cancelHandle;
        private boolean cancelled = false;
        private boolean aggressive = false;

        InProgress(RemotingInvocationRequest incomingInvocation) {
            this.incomingInvocation = incomingInvocation;
        }

        int getInvId() {
            return this.incomingInvocation.invId;
        }

        CancelHandle getCancelHandle() {
            return this.cancelHandle;
        }

        synchronized void setCancelHandle(CancelHandle cancelHandle) {
            this.cancelHandle = cancelHandle;
            if (this.cancelled) {
                cancelHandle.cancel(this.aggressive);
            }
        }

        synchronized void cancel(boolean aggressive) {
            this.cancelled = true;
            this.aggressive = aggressive;
            if (this.cancelHandle != null) {
                this.cancelHandle.cancel(aggressive);
            }
        }
    }

    final class RemotingInvocationRequest
    extends RemotingRequest
    implements InvocationRequest {
        final EJBIdentifier identifier;
        final EJBMethodLocator methodLocator;
        final ServerClassResolver classResolver;
        final Unmarshaller remaining;
        int txnCmd;

        RemotingInvocationRequest(int invId, EJBIdentifier identifier, EJBMethodLocator methodLocator, ServerClassResolver classResolver, Unmarshaller remaining, SecurityIdentity identity) {
            super(invId, identity);
            this.txnCmd = 0;
            this.identifier = identifier;
            this.methodLocator = methodLocator;
            this.classResolver = classResolver;
            this.remaining = remaining;
        }

        @Override
        public void convertToStateful(SessionID sessionId) throws IllegalArgumentException, IllegalStateException {
            if (EJBServerChannel.this.version < 3) {
                throw Logs.REMOTING.cannotAddSessionID();
            }
            super.convertToStateful(sessionId);
        }

        @Override
        public InvocationRequest.Resolved getRequestContent(ClassLoader classLoader) throws IOException, ClassNotFoundException {
            this.classResolver.setClassLoader(classLoader);
            final HashSet<String> retainContextDataKeys = new HashSet<String>();
            int responseCompressLevel = 0;
            try (Unmarshaller unmarshaller = this.remaining;){
                EJBLocator locator;
                Affinity weakAffinity = Affinity.NONE;
                ExceptionSupplier<ImportResult<Object>, SystemException> transactionSupplier = null;
                if (EJBServerChannel.this.version >= 3) {
                    weakAffinity = unmarshaller.readObject(Affinity.class);
                    if (weakAffinity == null) {
                        weakAffinity = Affinity.NONE;
                    }
                    int flags = unmarshaller.readUnsignedByte();
                    responseCompressLevel = flags & 0xF;
                    transactionSupplier = EJBServerChannel.this.readTransaction(unmarshaller);
                    locator = unmarshaller.readObject(EJBLocator.class);
                    if (this.identifier != locator.getIdentifier()) {
                        throw Logs.REMOTING.mismatchedMethodLocation();
                    }
                } else {
                    assert (EJBServerChannel.this.version <= 2);
                    locator = unmarshaller.readObject(EJBLocator.class);
                    if (this.identifier.getAppName() != locator.getAppName() || this.identifier.getModuleName() != locator.getModuleName() || this.identifier.getBeanName() != locator.getBeanName() || this.identifier.getDistinctName() != locator.getDistinctName()) {
                        throw Logs.REMOTING.mismatchedMethodLocation();
                    }
                    retainContextDataKeys.add("jboss.ejb.weak.affinity");
                }
                final Object[] parameters = new Object[this.methodLocator.getParameterCount()];
                for (int i = 0; i < parameters.length; ++i) {
                    parameters[i] = unmarshaller.readObject();
                }
                int attachmentCount = PackedInteger.readPackedInteger(unmarshaller);
                final HashMap<String, Object> attachments = new HashMap<String, Object>(attachmentCount);
                for (int i = 0; i < attachmentCount; ++i) {
                    String attName = unmarshaller.readObject(String.class);
                    if (attName.equals("org.jboss.ejb.client.invocation.attachments")) {
                        if (EJBServerChannel.this.version <= 2) {
                            Map map = (Map)unmarshaller.readObject();
                            Object transactionIdObject = map.get(AttachmentKeys.TRANSACTION_ID_KEY);
                            if (transactionIdObject != null) {
                                TransactionID transactionId = (TransactionID)transactionIdObject;
                                if (transactionId instanceof UserTransactionID) {
                                    transactionSupplier = () -> new ImportResult<LocalTransaction>(EJBServerChannel.this.transactionServer.getOrBeginTransaction(((UserTransactionID)transactionId).getId(), ContextTransactionManager.getGlobalDefaultTransactionTimeout()), SubordinateTransactionControl.EMPTY, false);
                                } else if (transactionId instanceof XidTransactionID) {
                                    transactionSupplier = () -> {
                                        try {
                                            return EJBServerChannel.this.transactionServer.getTransactionService().getTransactionContext().findOrImportTransaction(((XidTransactionID)transactionId).getXid(), ContextTransactionManager.getGlobalDefaultTransactionTimeout());
                                        }
                                        catch (XAException e) {
                                            throw new SystemException(e.getMessage());
                                        }
                                    };
                                } else {
                                    throw Assert.impossibleSwitchCase(transactionId);
                                }
                            }
                            weakAffinity = map.getOrDefault(AttachmentKeys.WEAK_AFFINITY, weakAffinity);
                            boolean compressResponse = map.getOrDefault(AttachmentKeys.COMPRESS_RESPONSE, false);
                            if (!compressResponse) continue;
                            responseCompressLevel = map.getOrDefault(AttachmentKeys.RESPONSE_COMPRESSION_LEVEL, 0);
                            continue;
                        }
                        unmarshaller.readObject();
                        continue;
                    }
                    Object value = unmarshaller.readObject();
                    if (value == null) continue;
                    attachments.put(attName, value);
                    if (!"jboss.returned.keys".equals(attName)) continue;
                    retainContextDataKeys.addAll((Collection)value);
                }
                attachments.put("jboss.source-address", EJBServerChannel.this.channel.getConnection().getPeerAddress());
                final ExceptionSupplier<ImportResult<?>, SystemException> finalTransactionSupplier = transactionSupplier;
                if (EJBServerChannel.this.version == 2) {
                    CompressionHint compressionHint;
                    Method invokedMethod = EJBServerChannel.findMethod(locator.getViewType(), this.methodLocator);
                    CompressionHint compressionHint2 = compressionHint = invokedMethod == null ? null : invokedMethod.getAnnotation(CompressionHint.class);
                    if (compressionHint == null) {
                        CompressionHint compressionHint3 = compressionHint = invokedMethod == null ? null : invokedMethod.getDeclaringClass().getAnnotation(CompressionHint.class);
                    }
                    if (compressionHint != null && compressionHint.compressResponse()) {
                        responseCompressLevel = compressionHint.compressionLevel();
                    }
                }
                final int finalResponseCompressLevel = responseCompressLevel == 15 ? -1 : Math.min(responseCompressLevel, 9);
                InvocationRequest.Resolved resolved = new InvocationRequest.Resolved(){

                    @Override
                    @NotNull
                    public Map<String, Object> getAttachments() {
                        return attachments;
                    }

                    @Override
                    @NotNull
                    public Object[] getParameters() {
                        return parameters;
                    }

                    @Override
                    @NotNull
                    public EJBLocator<?> getEJBLocator() {
                        return locator;
                    }

                    @Override
                    public boolean hasTransaction() {
                        return finalTransactionSupplier != null;
                    }

                    @Override
                    public Transaction getTransaction() throws SystemException, IllegalStateException {
                        if (finalTransactionSupplier == null) {
                            return null;
                        }
                        if (RemotingInvocationRequest.this.txnCmd != 0) {
                            throw new IllegalStateException();
                        }
                        ImportResult importResult = (ImportResult)finalTransactionSupplier.get();
                        RemotingInvocationRequest.this.txnCmd = importResult.isNew() ? 1 : 2;
                        return importResult.getTransaction();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void writeInvocationResult(Object result) {
                        try (MessageOutputStream underlying = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                            int count;
                            MessageOutputStream os;
                            if (finalResponseCompressLevel != 0) {
                                underlying.writeByte(27);
                                os = new WrapperMessageOutputStream(underlying, new DeflaterOutputStream((OutputStream)underlying, new Deflater(finalResponseCompressLevel)));
                            } else {
                                os = underlying;
                            }
                            os.writeByte(5);
                            os.writeShort(RemotingInvocationRequest.this.invId);
                            if (EJBServerChannel.this.version >= 3) {
                                byte[] bytes;
                                os.writeByte(RemotingInvocationRequest.this.txnCmd);
                                int updateBits = 0;
                                if (RemotingInvocationRequest.this.sessionId != null) {
                                    updateBits |= 1;
                                }
                                if (RemotingInvocationRequest.this.weakAffinityUpdate != null) {
                                    updateBits |= 2;
                                }
                                if (RemotingInvocationRequest.this.strongAffinityUpdate != null) {
                                    updateBits |= 4;
                                }
                                os.writeByte(updateBits);
                                if (RemotingInvocationRequest.this.sessionId != null) {
                                    byte[] bytes2 = RemotingInvocationRequest.this.sessionId.getEncodedForm();
                                    PackedInteger.writePackedInteger(os, bytes2.length);
                                    os.write(bytes2);
                                }
                                if (RemotingInvocationRequest.this.weakAffinityUpdate != null) {
                                    String nodeName = RemotingInvocationRequest.this.weakAffinityUpdate.getNodeName();
                                    bytes = nodeName.getBytes(StandardCharsets.UTF_8);
                                    PackedInteger.writePackedInteger(os, bytes.length);
                                    os.write(bytes);
                                }
                                if (RemotingInvocationRequest.this.strongAffinityUpdate != null) {
                                    String clusterName = RemotingInvocationRequest.this.strongAffinityUpdate.getClusterName();
                                    bytes = clusterName.getBytes(StandardCharsets.UTF_8);
                                    PackedInteger.writePackedInteger(os, bytes.length);
                                    os.write(bytes);
                                }
                            }
                            Marshaller marshaller = EJBServerChannel.this.marshallerFactory.createMarshaller(EJBServerChannel.this.configuration);
                            marshaller.start(new NoFlushByteOutput(Marshalling.createByteOutput(os)));
                            marshaller.writeObject(result);
                            attachments.keySet().retainAll(retainContextDataKeys);
                            if (EJBServerChannel.this.version >= 3) {
                                attachments.remove("jboss.ejb.weak.affinity");
                            }
                            if ((count = attachments.size()) > 255) {
                                marshaller.writeByte(255);
                            } else {
                                marshaller.writeByte(count);
                            }
                            int i = 0;
                            ProtocolObjectResolver.enableNonSerReplacement();
                            try {
                                for (Map.Entry entry : attachments.entrySet()) {
                                    marshaller.writeObject(entry.getKey());
                                    marshaller.writeObject(entry.getValue());
                                    if (i++ != 255) continue;
                                    break;
                                }
                            }
                            finally {
                                ProtocolObjectResolver.disableNonSerReplacement();
                            }
                            marshaller.finish();
                            os.close();
                        }
                        catch (IOException e) {
                            Logs.REMOTING.ioExceptionOnEJBResponseWrite(RemotingInvocationRequest.this.invId, EJBServerChannel.this.channel, e);
                        }
                        finally {
                            EJBServerChannel.this.invocations.removeKey(RemotingInvocationRequest.this.invId);
                        }
                    }
                };
                return resolved;
            }
        }

        @Override
        public void writeProceedAsync() {
            if (EJBServerChannel.this.version >= 3) {
                return;
            }
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(14);
                os.writeShort(this.invId);
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnProceedAsyncResponseWrite(this.invId, EJBServerChannel.this.channel, e);
            }
        }

        @Override
        @NotNull
        public EJBIdentifier getEJBIdentifier() {
            return this.identifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeNoSuchMethod() {
            String message = Logs.REMOTING.remoteMessageNoSuchMethod(this.methodLocator, this.identifier);
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(11);
                os.writeShort(this.invId);
                os.writeUTF(message);
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnEJBResponseWrite(this.invId, EJBServerChannel.this.channel, e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeSessionNotActive() {
            String message = Logs.REMOTING.remoteMessageSessionNotActive(this.methodLocator, this.identifier);
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(11);
                os.writeShort(this.invId);
                os.writeUTF(message);
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnEJBResponseWrite(this.invId, EJBServerChannel.this.channel, e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }

        @Override
        int getEnlistmentStatus() {
            return this.txnCmd;
        }

        @Override
        public void writeException(@NotNull Exception exception) {
            Assert.checkNotNullParam("exception", exception);
            this.writeFailure(exception);
        }

        @Override
        public EJBMethodLocator getMethodLocator() {
            return this.methodLocator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeCancellation() {
            if (EJBServerChannel.this.version >= 3) {
                try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                    os.writeByte(7);
                    os.writeShort(this.invId);
                }
                catch (IOException e) {
                    Logs.REMOTING.ioExceptionOnEJBResponseWrite(this.invId, EJBServerChannel.this.channel, e);
                }
                finally {
                    EJBServerChannel.this.invocations.removeKey(this.invId);
                }
            } else {
                this.writeFailure(Logs.REMOTING.requestCancelled());
            }
        }
    }

    final class RemotingSessionOpenRequest
    extends RemotingRequest
    implements SessionOpenRequest {
        private final EJBIdentifier identifier;
        final ExceptionSupplier<ImportResult<?>, SystemException> transactionSupplier;
        int txnCmd;

        RemotingSessionOpenRequest(int invId, EJBIdentifier identifier, ExceptionSupplier<ImportResult<?>, SystemException> transactionSupplier, SecurityIdentity identity) {
            super(invId, identity);
            this.txnCmd = 0;
            this.transactionSupplier = transactionSupplier;
            this.identifier = identifier;
        }

        @Override
        @NotNull
        public EJBIdentifier getEJBIdentifier() {
            return this.identifier;
        }

        @Override
        public boolean hasTransaction() {
            return this.transactionSupplier != null;
        }

        @Override
        public Transaction getTransaction() throws SystemException, IllegalStateException {
            ExceptionSupplier<ImportResult<?>, SystemException> transactionSupplier = this.transactionSupplier;
            if (transactionSupplier == null) {
                return null;
            }
            if (this.txnCmd != 0) {
                throw new IllegalStateException();
            }
            ImportResult<?> importResult = transactionSupplier.get();
            this.txnCmd = importResult.isNew() ? 1 : 2;
            return importResult.getTransaction();
        }

        @Override
        int getEnlistmentStatus() {
            return this.txnCmd;
        }

        @Override
        public void writeException(@NotNull Exception exception) {
            Assert.checkNotNullParam("exception", exception);
            this.writeFailure(exception);
        }

        @Override
        public void convertToStateful(@NotNull SessionID sessionId) throws IllegalArgumentException, IllegalStateException {
            super.convertToStateful(sessionId);
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(2);
                os.writeShort(this.invId);
                byte[] encodedForm = sessionId.getEncodedForm();
                PackedInteger.writePackedInteger(os, encodedForm.length);
                os.write(encodedForm);
                if (1 <= EJBServerChannel.this.version && EJBServerChannel.this.version <= 2) {
                    Marshaller marshaller = EJBServerChannel.this.marshallerFactory.createMarshaller(EJBServerChannel.this.configuration);
                    marshaller.start(new NoFlushByteOutput(Marshalling.createByteOutput(os)));
                    if (this.strongAffinityUpdate != null) {
                        marshaller.writeObject(this.strongAffinityUpdate);
                    } else {
                        marshaller.writeObject(new NodeAffinity(EJBServerChannel.this.channel.getConnection().getEndpoint().getName()));
                    }
                    marshaller.finish();
                } else {
                    byte[] bytes;
                    assert (EJBServerChannel.this.version >= 3);
                    os.writeByte(this.txnCmd);
                    int updateBits = 0;
                    if (this.weakAffinityUpdate != null) {
                        updateBits |= 2;
                    }
                    if (this.strongAffinityUpdate != null) {
                        updateBits |= 4;
                    }
                    os.writeByte(updateBits);
                    if (this.weakAffinityUpdate != null) {
                        String nodeName = this.weakAffinityUpdate.getNodeName();
                        bytes = nodeName.getBytes(StandardCharsets.UTF_8);
                        PackedInteger.writePackedInteger(os, bytes.length);
                        os.write(bytes);
                    }
                    if (this.strongAffinityUpdate != null) {
                        String clusterName = this.strongAffinityUpdate.getClusterName();
                        bytes = clusterName.getBytes(StandardCharsets.UTF_8);
                        PackedInteger.writePackedInteger(os, bytes.length);
                        os.write(bytes);
                    }
                }
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnEJBSessionOpenResponseWrite(this.invId, EJBServerChannel.this.channel, e);
            }
        }
    }

    abstract class RemotingRequest
    implements Request {
        final int invId;
        SessionID sessionId;
        final SecurityIdentity identity;
        ClusterAffinity strongAffinityUpdate;
        NodeAffinity weakAffinityUpdate;

        RemotingRequest(int invId, SecurityIdentity identity) {
            this.invId = invId;
            this.identity = identity;
        }

        @Override
        public Executor getRequestExecutor() {
            return EJBServerChannel.this.channel.getConnection().getEndpoint().getXnioWorker();
        }

        @Override
        public SocketAddress getPeerAddress() {
            return EJBServerChannel.this.channel.getConnection().getPeerAddress();
        }

        @Override
        public SocketAddress getLocalAddress() {
            return EJBServerChannel.this.channel.getConnection().getLocalAddress();
        }

        @Override
        public String getProtocol() {
            return EJBServerChannel.this.channel.getConnection().getProtocol();
        }

        @Override
        public boolean isBlockingCaller() {
            return false;
        }

        @Override
        public SecurityIdentity getSecurityIdentity() {
            return this.identity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeNoSuchEJB() {
            String message = Logs.REMOTING.remoteMessageNoSuchEJB(this.getEJBIdentifier());
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(10);
                os.writeShort(this.invId);
                os.writeUTF(message);
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnEJBResponseWrite(this.invId, EJBServerChannel.this.channel, e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeWrongViewType() {
            String message = Logs.REMOTING.remoteMessageBadViewType(this.getEJBIdentifier());
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                if (EJBServerChannel.this.version >= 3) {
                    os.writeByte(28);
                    os.writeShort(this.invId);
                    os.writeUTF(message);
                } else {
                    os.writeByte(6);
                    os.writeShort(this.invId);
                    Marshaller marshaller = EJBServerChannel.this.marshallerFactory.createMarshaller(EJBServerChannel.this.configuration);
                    marshaller.start(new NoFlushByteOutput(Marshalling.createByteOutput(os)));
                    marshaller.writeObject(Logs.REMOTING.invalidViewTypeForInvocation(message));
                    marshaller.writeByte(0);
                    marshaller.finish();
                }
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnEJBResponseWrite(this.invId, EJBServerChannel.this.channel, e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeCancelResponse() {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(7);
                os.writeShort(this.invId);
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnEJBResponseWrite(this.invId, EJBServerChannel.this.channel, e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeNotStateful() {
            String message = Logs.REMOTING.remoteMessageEJBNotStateful(this.getEJBIdentifier());
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(13);
                os.writeShort(this.invId);
                os.writeUTF(message);
            }
            catch (IOException e) {
                Logs.REMOTING.ioExceptionOnEJBResponseWrite(this.invId, EJBServerChannel.this.channel, e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }

        @Override
        public void convertToStateful(@NotNull SessionID sessionId) throws IllegalArgumentException, IllegalStateException {
            Assert.checkNotNullParam("sessionId", sessionId);
            SessionID ourSessionId = this.sessionId;
            if (ourSessionId != null) {
                if (!sessionId.equals((Object)ourSessionId)) {
                    throw new IllegalStateException();
                }
            } else {
                this.sessionId = sessionId;
            }
        }

        @Override
        public <C> C getProviderInterface(Class<C> providerInterfaceType) {
            Connection connection = EJBServerChannel.this.channel.getConnection();
            return providerInterfaceType.isInstance(connection) ? (C)providerInterfaceType.cast(connection) : null;
        }

        abstract int getEnlistmentStatus();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeFailure(Exception reason) {
            try (MessageOutputStream os = EJBServerChannel.this.messageTracker.openMessageUninterruptibly();){
                os.writeByte(6);
                os.writeShort(this.invId);
                if (EJBServerChannel.this.version >= 3) {
                    os.writeByte(this.getEnlistmentStatus());
                }
                Marshaller marshaller = EJBServerChannel.this.marshallerFactory.createMarshaller(EJBServerChannel.this.configuration);
                marshaller.start(new NoFlushByteOutput(Marshalling.createByteOutput(os)));
                marshaller.writeObject(reason);
                marshaller.writeByte(0);
                marshaller.finish();
            }
            catch (IOException e) {
                e.addSuppressed(reason);
                Logs.REMOTING.ioExceptionOnEJBResponseWrite(this.invId, EJBServerChannel.this.channel, e);
            }
            finally {
                EJBServerChannel.this.invocations.removeKey(this.invId);
            }
        }

        @Override
        public void updateStrongAffinity(@NotNull Affinity affinity) {
            Assert.checkNotNullParam("affinity", affinity);
            if (affinity instanceof ClusterAffinity) {
                this.strongAffinityUpdate = (ClusterAffinity)affinity;
            }
        }

        @Override
        public void updateWeakAffinity(@NotNull Affinity affinity) {
            Assert.checkNotNullParam("affinity", affinity);
            if (affinity instanceof NodeAffinity) {
                this.weakAffinityUpdate = (NodeAffinity)affinity;
            }
        }
    }
}

