package org.apache.activemq.artemis.jms.client;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-09-21T13:46:31-0400")
public class ActiveMQJMSClientLogger_$logger extends DelegatingBasicLogger implements ActiveMQJMSClientLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQJMSClientLogger_$logger.class.getName();
    public ActiveMQJMSClientLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void connectionLeftOpen(final Exception e) {
        super.log.logv(FQCN, WARN, e, connectionLeftOpen$str());
    }
    protected String connectionLeftOpen$str() {
        return "AMQ132000: I''m closing a JMS connection you left open. Please make sure you close all JMS connections explicitly before letting them go out of scope! see stacktrace to find out where it was created";
    }
    @Override
    public final void onMessageError(final Exception e) {
        super.log.logv(FQCN, WARN, e, onMessageError$str());
    }
    protected String onMessageError$str() {
        return "AMQ132001: Unhandled exception thrown from onMessage";
    }
    @Override
    public final void errorCallingExcListener(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorCallingExcListener$str());
    }
    protected String errorCallingExcListener$str() {
        return "AMQ134000: Failed to call JMS exception listener";
    }
    @Override
    public final void errorCreatingMessage(final String messageToString, final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorCreatingMessage$str(), messageToString);
    }
    protected String errorCreatingMessage$str() {
        return "AMQ134002: Queue Browser failed to create message {0}";
    }
    @Override
    public final void errorPreparingMessageForReceipt(final String messagetoString, final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorPreparingMessageForReceipt$str(), messagetoString);
    }
    protected String errorPreparingMessageForReceipt$str() {
        return "AMQ134003: Message Listener failed to prepare message for receipt, message={0}";
    }
    @Override
    public final void errorProcessingMessage(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorProcessingMessage$str());
    }
    protected String errorProcessingMessage$str() {
        return "AMQ134004: Message Listener failed to process message";
    }
    @Override
    public final void errorRecoveringSession(final Throwable e) {
        super.log.logv(FQCN, ERROR, e, errorRecoveringSession$str());
    }
    protected String errorRecoveringSession$str() {
        return "AMQ134005: Message Listener failed to recover session";
    }
    @Override
    public final void errorCallingFailoverListener(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorCallingFailoverListener$str());
    }
    protected String errorCallingFailoverListener$str() {
        return "AMQ134006: Failed to call Failover listener";
    }
}
