/** This class is auto generated by org.apache.activemq.artemis.logs.annotation.processor.LogAnnotationProcessor
    and it inherits whatever license is declared at org.apache.activemq.artemis.logs.ActiveMQUtilLogger */

package org.apache.activemq.artemis.logs;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

// @org.apache.activemq.artemis.logs.annotation.LogBundle(regexID="20[0-9]{4}", projectCode="AMQ")
public class ActiveMQUtilLogger_impl implements ActiveMQUtilLogger
{
   private final Logger logger;

   private static void _copyStackTraceMinusOne(final Throwable e) {
      final StackTraceElement[] st = e.getStackTrace();
      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
   }

   public ActiveMQUtilLogger_impl(Logger logger ) {
      this.logger = logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=201000, value=\"Network is healthy, starting service {}\", level=INFO)
   @Override
   public void startingService(java.lang.String component) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ201000: Network is healthy, starting service {}", component);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=201001, value=\"Network is unhealthy, stopping service {}\", level=WARN)
   @Override
   public void stoppingService(java.lang.String component) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ201001: Network is unhealthy, stopping service {}", component);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202000, value=\"Missing privileges to set Thread Context Class Loader on Thread Factory. Using current Thread Context Class Loader\", level=WARN)
   @Override
   public void missingPrivsForClassloader() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202000: Missing privileges to set Thread Context Class Loader on Thread Factory. Using current Thread Context Class Loader");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202001, value=\"{} is a loopback address and will be discarded.\", level=WARN)
   @Override
   public void addressloopback(java.lang.String address) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202001: {} is a loopback address and will be discarded.", address);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202002, value=\"Ping Address {} wasn't reacheable.\", level=WARN)
   @Override
   public void addressWasntReacheable(java.lang.String address) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202002: Ping Address {} wasn't reacheable.", address);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202003, value=\"Ping Url {} wasn't reacheable.\", level=WARN)
   @Override
   public void urlWasntReacheable(java.lang.String url) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202003: Ping Url {} wasn't reacheable.", url);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202004, value=\"Error starting component {} \", level=WARN)
   @Override
   public void errorStartingComponent(java.lang.String component, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202004: Error starting component {} ", component, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202005, value=\"Error stopping component {} \", level=WARN)
   @Override
   public void errorStoppingComponent(java.lang.String component, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202005: Error stopping component {} ", component, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202006, value=\"Failed to check Url {}.\", level=WARN)
   @Override
   public void failedToCheckURL(java.lang.String url, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202006: Failed to check Url {}.", url, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202007, value=\"Failed to check Address {}.\", level=WARN)
   @Override
   public void failedToCheckAddress(java.lang.String address, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202007: Failed to check Address {}.", address, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202008, value=\"Failed to check Address list {}.\", level=WARN)
   @Override
   public void failedToParseAddressList(java.lang.String addressList, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202008: Failed to check Address list {}.", addressList, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202009, value=\"Failed to check Url list {}.\", level=WARN)
   @Override
   public void failedToParseUrlList(java.lang.String urlList, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202009: Failed to check Url list {}.", urlList, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202010, value=\"Failed to set NIC {}.\", level=WARN)
   @Override
   public void failedToSetNIC(java.lang.String nic, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202010: Failed to set NIC {}.", nic, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202011, value=\"Failed to read from stream {}.\", level=WARN)
   @Override
   public void failedToReadFromStream(java.lang.String stream) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202011: Failed to read from stream {}.", stream);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202012, value=\"Object cannot be serialized.\", level=WARN)
   @Override
   public void failedToSerializeObject(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202012: Object cannot be serialized.", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202013, value=\"Unable to deserialize object.\", level=WARN)
   @Override
   public void failedToDeserializeObject(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202013: Unable to deserialize object.", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202014, value=\"Unable to encode byte array into Base64 notation.\", level=WARN)
   @Override
   public void failedToEncodeByteArrayToBase64Notation(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202014: Unable to encode byte array into Base64 notation.", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202015, value=\"Failed to clean up file {}\", level=WARN)
   @Override
   public void failedToCleanupFile(java.lang.String file) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202015: Failed to clean up file {}", file);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202016, value=\"Could not list files to clean up in {}\", level=WARN)
   @Override
   public void failedListFilesToCleanup(java.lang.String path) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202016: Could not list files to clean up in {}", path);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=202017, value=\"Algorithm two-way is deprecated and will be removed from the default codec in a future version. Use a custom codec instead. Consult the manual for details.\", level=WARN)
   @Override
   public void deprecatedDefaultCodecTwoWayAlgorithm() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ202017: Algorithm two-way is deprecated and will be removed from the default codec in a future version. Use a custom codec instead. Consult the manual for details.");
      }
   }

}
