/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Global;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.Component;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.MsgStats;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;

@MBean(description="Protocol which exposes various statistics such as sent messages, number of bytes received etc")
public class STATS
extends Protocol {
    protected static final Address NULL_DEST = Global.NULL_ADDRESS;
    @Component
    protected final MsgStats mstats = new MsgStats();
    protected final ConcurrentMap<Address, MsgStats> sent = new ConcurrentHashMap<Address, MsgStats>();
    protected final ConcurrentMap<Address, MsgStats> received = new ConcurrentHashMap<Address, MsgStats>();
    protected static final Function<Address, MsgStats> FUNC = __ -> new MsgStats();

    @Override
    public void resetStats() {
        this.mstats.reset();
        this.sent.clear();
        this.received.clear();
    }

    @Override
    public Object down(Event evt) {
        if (evt.getType() == 6) {
            this.handleViewChange((View)evt.getArg());
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        this.sent(msg);
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Event evt) {
        if (evt.getType() == 6) {
            this.handleViewChange((View)evt.getArg());
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        this.received(msg);
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        this.received(batch);
        this.up_prot.up(batch);
    }

    @ManagedOperation
    public String printStats() {
        Object val;
        Object key;
        StringBuilder sb = new StringBuilder();
        sb.append("sent:\n");
        for (Map.Entry entry : this.sent.entrySet()) {
            key = entry.getKey();
            if (key == NULL_DEST) {
                key = "<mcast dest>";
            }
            val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        sb.append("\nreceived:\n");
        for (Map.Entry entry : this.received.entrySet()) {
            key = entry.getKey();
            val = entry.getValue();
            sb.append(key).append(": ").append(val).append("\n");
        }
        return sb.toString();
    }

    protected void handleViewChange(View view) {
        List<Address> members = view.getMembers();
        LinkedHashSet<Address> tmp = new LinkedHashSet<Address>(members);
        tmp.add(null);
        this.sent.keySet().retainAll(tmp);
        this.received.keySet().retainAll(tmp);
    }

    protected void sent(Message msg) {
        this.mstats.sent(msg);
        Address key = msg.dest();
        if (key == null) {
            key = NULL_DEST;
        }
        MsgStats entry = this.sent.computeIfAbsent(key, FUNC);
        entry.sent(msg);
    }

    protected void received(Message msg) {
        this.mstats.received(msg);
        Address key = msg.src();
        if (key == null) {
            key = NULL_DEST;
        }
        MsgStats entry = this.received.computeIfAbsent(key, FUNC);
        entry.received(msg);
    }

    protected void received(MessageBatch batch) {
        this.mstats.received(batch);
        Address key = batch.sender();
        if (key == null) {
            key = NULL_DEST;
        }
        MsgStats entry = this.received.computeIfAbsent(key, FUNC);
        entry.received(batch);
    }
}

