/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionForContextImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionMetaData;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientLogger;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.jms.client.ActiveMQXASession;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.jms.client.JMSExceptionHelper;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;

public class ActiveMQConnection
extends ActiveMQConnectionForContextImpl
implements TopicConnection,
QueueConnection {
    public static final int TYPE_GENERIC_CONNECTION = 0;
    public static final int TYPE_QUEUE_CONNECTION = 1;
    public static final int TYPE_TOPIC_CONNECTION = 2;
    public static final String EXCEPTION_FAILOVER = "FAILOVER";
    public static final String EXCEPTION_DISCONNECT = "DISCONNECT";
    public static final SimpleString CONNECTION_ID_PROPERTY_NAME = MessageUtil.CONNECTION_ID_PROPERTY_NAME;
    private final int connectionType;
    private final Set<ActiveMQSession> sessions = new ConcurrentHashSet<ActiveMQSession>();
    private final Set<SimpleString> tempQueues = new ConcurrentHashSet<SimpleString>();
    private volatile boolean hasNoLocal;
    private volatile ExceptionListener exceptionListener;
    private volatile FailoverEventListener failoverEventListener;
    private volatile boolean justCreated = true;
    private volatile ConnectionMetaData metaData;
    private volatile boolean closed;
    private volatile boolean started;
    private String clientID;
    private final ClientSessionFactory sessionFactory;
    private final SimpleString uid;
    private final String username;
    private final String password;
    private final SessionFailureListener listener = new JMSFailureListener(this);
    private final FailoverEventListener failoverListener = new FailoverEventListenerImpl(this);
    private final ExecutorService failoverListenerExecutor = Executors.newFixedThreadPool(1, ActiveMQThreadFactory.defaultThreadFactory(this.getClass().getName()));
    private final Version thisVersion;
    private final int dupsOKBatchSize;
    private final int transactionBatchSize;
    private final boolean cacheDestinations;
    private final boolean enable1xPrefixes;
    private ClientSession initialSession;
    private final Exception creationStack;
    private ActiveMQConnectionFactory factoryReference;
    private final ConnectionFactoryOptions options;

    public ActiveMQConnection(ConnectionFactoryOptions options, String username, String password, int connectionType, String clientID, int dupsOKBatchSize, int transactionBatchSize, boolean cacheDestinations, boolean enable1xPrefixes, ClientSessionFactory sessionFactory) {
        this.options = options;
        this.username = username;
        this.password = password;
        this.connectionType = connectionType;
        this.clientID = clientID;
        this.sessionFactory = sessionFactory;
        this.uid = UUIDGenerator.getInstance().generateSimpleStringUUID();
        this.thisVersion = VersionLoader.getVersion();
        this.dupsOKBatchSize = dupsOKBatchSize;
        this.transactionBatchSize = transactionBatchSize;
        this.cacheDestinations = cacheDestinations;
        this.enable1xPrefixes = enable1xPrefixes;
        this.creationStack = new Exception();
    }

    public synchronized Session createNonXASession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, transacted, acknowledgeMode, 0);
    }

    public synchronized Session createNonXATopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, transacted, acknowledgeMode, 2);
    }

    public synchronized Session createNonXAQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, transacted, acknowledgeMode, 1);
    }

    @Override
    public synchronized Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, transacted, ActiveMQConnection.checkAck(transacted, acknowledgeMode), 0);
    }

    @Override
    public String getClientID() throws JMSException {
        this.checkClosed();
        return this.clientID;
    }

    @Override
    public void setClientID(String clientID) throws JMSException {
        this.checkClosed();
        if (this.clientID != null) {
            throw new IllegalStateException("Client id has already been set");
        }
        if (!this.justCreated) {
            throw new IllegalStateException("setClientID can only be called directly after the connection is created");
        }
        try {
            this.validateClientID(this.initialSession, clientID);
            this.clientID = clientID;
            this.addSessionMetaData(this.initialSession);
        }
        catch (ActiveMQException e) {
            JMSException ex = new JMSException("Internal error setting metadata jms-client-id");
            ex.setLinkedException(e);
            ex.initCause(e);
            throw ex;
        }
        this.justCreated = false;
    }

    private void validateClientID(ClientSession validateSession, String clientID) throws InvalidClientIDException, ActiveMQException {
        try {
            validateSession.addUniqueMetaData("jms-client-id", clientID);
        }
        catch (ActiveMQException e) {
            if (e.getType() == ActiveMQExceptionType.DUPLICATE_METADATA) {
                throw new InvalidClientIDException("clientID=" + clientID + " was already set into another connection");
            }
            throw e;
        }
    }

    @Override
    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        if (this.metaData == null) {
            this.metaData = new ActiveMQConnectionMetaData(this.thisVersion);
        }
        return this.metaData;
    }

    @Override
    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this.exceptionListener;
    }

    @Override
    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        this.exceptionListener = listener;
    }

    @Override
    public synchronized void start() throws JMSException {
        this.checkClosed();
        for (ActiveMQSession session : this.sessions) {
            session.start();
        }
        this.justCreated = false;
        this.started = true;
    }

    public synchronized void signalStopToAllSessions() {
        for (ActiveMQSession session : this.sessions) {
            ClientSession coreSession = session.getCoreSession();
            if (!(coreSession instanceof ClientSessionInternal)) continue;
            ClientSessionInternal clientSessionInternal = (ClientSessionInternal)coreSession;
            clientSessionInternal.setStopSignal();
        }
    }

    @Override
    public synchronized void stop() throws JMSException {
        this.threadAwareContext.assertNotMessageListenerThread();
        this.checkClosed();
        for (ActiveMQSession session : this.sessions) {
            session.stop();
        }
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void close() throws JMSException {
        this.threadAwareContext.assertNotCompletionListenerThread();
        this.threadAwareContext.assertNotMessageListenerThread();
        if (this.closed) {
            return;
        }
        this.sessionFactory.close();
        try {
            for (ActiveMQSession session : new HashSet<ActiveMQSession>(this.sessions)) {
                session.close();
            }
            try {
                if (!this.tempQueues.isEmpty()) {
                    for (SimpleString queueName : this.tempQueues) {
                        if (this.initialSession.isClosed()) continue;
                        try {
                            this.initialSession.deleteQueue(queueName);
                        }
                        catch (ActiveMQException activeMQException) {}
                    }
                }
            }
            finally {
                if (this.initialSession != null) {
                    this.initialSession.close();
                }
            }
            AccessController.doPrivileged(() -> {
                this.failoverListenerExecutor.shutdown();
                return null;
            });
            this.closed = true;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.checkTempQueues(destination);
        return null;
    }

    private void checkTempQueues(Destination destination) throws JMSException {
        ActiveMQDestination jbdest = (ActiveMQDestination)destination;
        if (jbdest.isTemporary() && !this.containsTemporaryQueue(jbdest.getSimpleAddress())) {
            throw new JMSException("Can not create consumer for temporary destination " + String.valueOf(destination) + " from another JMS connection");
        }
    }

    @Override
    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        if (this.connectionType == 1) {
            String msg = "Cannot create a durable connection consumer on a QueueConnection";
            throw new IllegalStateException(msg);
        }
        this.checkTempQueues(topic);
        return null;
    }

    @Override
    public synchronized Session createSession(int sessionMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, sessionMode == 0, sessionMode, 0);
    }

    @Override
    public synchronized Session createSession() throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, false, 1, 0);
    }

    @Override
    public synchronized QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, transacted, ActiveMQConnection.checkAck(transacted, acknowledgeMode), 1);
    }

    public static int checkAck(boolean transacted, int acknowledgeMode) {
        if (!transacted && acknowledgeMode == 0) {
            return 1;
        }
        return acknowledgeMode;
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.checkTempQueues(queue);
        return null;
    }

    @Override
    public synchronized TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(false, transacted, ActiveMQConnection.checkAck(transacted, acknowledgeMode), 2);
    }

    @Override
    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.checkTempQueues(topic);
        return null;
    }

    @Override
    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return null;
    }

    @Override
    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return null;
    }

    public void setFailoverListener(FailoverEventListener listener) throws JMSException {
        this.checkClosed();
        this.justCreated = false;
        this.failoverEventListener = listener;
    }

    public FailoverEventListener getFailoverListener() throws JMSException {
        this.checkClosed();
        this.justCreated = false;
        return this.failoverEventListener;
    }

    public void addTemporaryQueue(SimpleString queueAddress) {
        this.tempQueues.add(queueAddress);
    }

    public void removeTemporaryQueue(SimpleString queueAddress) {
        this.tempQueues.remove(queueAddress);
    }

    public boolean containsTemporaryQueue(SimpleString queueAddress) {
        return this.tempQueues.contains(queueAddress);
    }

    public boolean hasNoLocal() {
        return this.hasNoLocal;
    }

    public void setHasNoLocal() {
        this.hasNoLocal = true;
    }

    public SimpleString getUID() {
        return this.uid;
    }

    public void removeSession(ActiveMQSession session) {
        this.sessions.remove(session);
    }

    public ClientSession getInitialSession() {
        return this.initialSession;
    }

    protected boolean isXA() {
        return false;
    }

    protected final ActiveMQSession createSessionInternal(boolean isXA, boolean transacted, int acknowledgeMode, int type) throws JMSException {
        if (transacted) {
            acknowledgeMode = 0;
        }
        try {
            ClientSession session;
            boolean isBlockOnAcknowledge = this.sessionFactory.getServerLocator().isBlockOnAcknowledge();
            int ackBatchSize = this.sessionFactory.getServerLocator().getAckBatchSize();
            if (acknowledgeMode == 0) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, false, false, this.sessionFactory.getServerLocator().isPreAcknowledge(), this.transactionBatchSize, this.clientID);
            } else if (acknowledgeMode == 1) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, true, this.sessionFactory.getServerLocator().isPreAcknowledge(), 0, this.clientID);
            } else if (acknowledgeMode == 3) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, true, this.sessionFactory.getServerLocator().isPreAcknowledge(), this.dupsOKBatchSize, this.clientID);
            } else if (acknowledgeMode == 2) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, false, this.sessionFactory.getServerLocator().isPreAcknowledge(), isBlockOnAcknowledge ? this.transactionBatchSize : ackBatchSize, this.clientID);
            } else if (acknowledgeMode == 101) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, false, false, isBlockOnAcknowledge ? this.transactionBatchSize : ackBatchSize, this.clientID);
            } else if (acknowledgeMode == 100) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, false, true, this.transactionBatchSize, this.clientID);
            } else {
                throw new JMSRuntimeException("Invalid ackmode: " + acknowledgeMode);
            }
            this.justCreated = false;
            session.addFailureListener(this.listener);
            session.addFailoverListener(this.failoverListener);
            ActiveMQSession jbs = this.createAMQSession(isXA, transacted, acknowledgeMode, session, type);
            this.sessions.add(jbs);
            if (this.started) {
                session.start();
            }
            return jbs;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    public ClientSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected ActiveMQSession createAMQSession(boolean isXA, boolean transacted, int acknowledgeMode, ClientSession session, int type) {
        if (isXA) {
            return new ActiveMQXASession(this.options, this, transacted, true, acknowledgeMode, this.cacheDestinations, this.enable1xPrefixes, session, type);
        }
        return new ActiveMQSession(this.options, this, transacted, false, acknowledgeMode, this.cacheDestinations, this.enable1xPrefixes, session, type);
    }

    protected final void checkClosed() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    public void authorize() throws JMSException {
        this.authorize(true);
    }

    public void authorize(boolean validateClientId) throws JMSException {
        try {
            this.initialSession = this.sessionFactory.createSession(this.username, this.password, false, false, false, false, 0, this.clientID);
            if (this.clientID != null) {
                if (validateClientId) {
                    this.validateClientID(this.initialSession, this.clientID);
                } else {
                    this.initialSession.addMetaData("jms-client-id", this.clientID);
                }
            }
            this.addSessionMetaData(this.initialSession);
            this.initialSession.addFailureListener(this.listener);
            this.initialSession.addFailoverListener(this.failoverListener);
        }
        catch (ActiveMQException me) {
            throw JMSExceptionHelper.convertFromActiveMQException(me);
        }
    }

    private void addSessionMetaData(ClientSession session) throws ActiveMQException {
        session.addMetaData("jms-session", "");
        if (this.clientID != null) {
            session.addMetaData("jms-client-id", this.clientID);
        }
    }

    public void setReference(ActiveMQConnectionFactory factory) {
        this.factoryReference = factory;
    }

    public boolean isStarted() {
        return this.started;
    }

    @Deprecated(forRemoval=true)
    public String getDeserializationBlackList() {
        return this.getDeserializationDenyList();
    }

    @Deprecated(forRemoval=true)
    public String getDeserializationWhiteList() {
        return this.getDeserializationAllowList();
    }

    public String getDeserializationDenyList() {
        return this.factoryReference.getDeserializationDenyList();
    }

    public String getDeserializationAllowList() {
        return this.factoryReference.getDeserializationAllowList();
    }

    private static class JMSFailureListener
    implements SessionFailureListener {
        private final WeakReference<ActiveMQConnection> connectionRef;

        JMSFailureListener(ActiveMQConnection connection) {
            this.connectionRef = new WeakReference<ActiveMQConnection>(connection);
        }

        @Override
        public synchronized void connectionFailed(ActiveMQException me, boolean failedOver) {
            block5: {
                if (me == null) {
                    return;
                }
                ActiveMQConnection conn = (ActiveMQConnection)this.connectionRef.get();
                if (conn != null) {
                    try {
                        ExceptionListener exceptionListener = conn.getExceptionListener();
                        if (exceptionListener != null) {
                            JMSException je = new JMSException(me.toString(), failedOver ? ActiveMQConnection.EXCEPTION_FAILOVER : ActiveMQConnection.EXCEPTION_DISCONNECT);
                            je.initCause(me);
                            new Thread(() -> exceptionListener.onException(je)).start();
                        }
                    }
                    catch (JMSException e) {
                        if (conn.closed) break block5;
                        ActiveMQJMSClientLogger.LOGGER.errorCallingExcListener(e);
                    }
                }
            }
        }

        @Override
        public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
            this.connectionFailed(me, failedOver);
        }

        @Override
        public void beforeReconnect(ActiveMQException me) {
        }
    }

    private static class FailoverEventListenerImpl
    implements FailoverEventListener {
        private final WeakReference<ActiveMQConnection> connectionRef;

        FailoverEventListenerImpl(ActiveMQConnection connection) {
            this.connectionRef = new WeakReference<ActiveMQConnection>(connection);
        }

        @Override
        public void failoverEvent(FailoverEventType eventType) {
            block4: {
                ActiveMQConnection conn = (ActiveMQConnection)this.connectionRef.get();
                if (conn != null) {
                    try {
                        FailoverEventListener failoverListener = conn.getFailoverListener();
                        if (failoverListener != null) {
                            conn.failoverListenerExecutor.execute(() -> failoverListener.failoverEvent(eventType));
                        }
                    }
                    catch (JMSException e) {
                        if (conn.closed) break block4;
                        ActiveMQJMSClientLogger.LOGGER.errorCallingFailoverListener(e);
                    }
                }
            }
        }
    }
}

