/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.as.cli.parsing.arguments.ArgumentValueCallbackHandler;
import org.jboss.as.cli.parsing.arguments.ArgumentValueInitialState;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.diff.ProvisionedFeatureDiffCallback;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.state.ProvisionedFeature;

public class WfFeatureDiffCallback
implements ProvisionedFeatureDiffCallback {
    private static final String CORE_SERVICE_CONTAINER = "core-service.service-container";
    private static final String SERVER_ROOT = "server-root";
    private static final String AUTH_CONSTRAINT = "core-service.management.access.authorization.constraint.";
    private static final Object EMPTY_LIST_OR_OBJ = new Object();

    public boolean added(ProvisionedFeature added) throws ProvisioningException {
        String specName = added.getSpecId().getName();
        return !specName.equals(CORE_SERVICE_CONTAINER) && !specName.startsWith(AUTH_CONSTRAINT) && !specName.equals(SERVER_ROOT);
    }

    public boolean removed(ProvisionedFeature removed) throws ProvisioningException {
        String specName = removed.getSpecId().getName();
        return !specName.equals(SERVER_ROOT);
    }

    public boolean matches(ProvisionedFeature original, ProvisionedFeature actual) throws ProvisioningException {
        HashSet paramNames = new HashSet(actual.getParamNames());
        for (String paramName : original.getParamNames()) {
            String originalStr = original.getConfigParam(paramName);
            if (paramNames.remove(paramName)) {
                Object originalValue = WfFeatureDiffCallback.resolve(paramName, originalStr);
                String actualStr = actual.getConfigParam(paramName);
                if (originalValue.getClass().equals(String.class) && originalValue.equals(actualStr) || originalValue.equals(WfFeatureDiffCallback.resolve(paramName, actualStr))) continue;
                return false;
            }
            String specName = original.getSpecId().getName();
            if ("GLN_UNDEFINED".equals(originalStr) || paramName.equals("extension") && specName.startsWith("subsystem.") || paramName.equals("persist-name") && specName.equals("host") || WfFeatureDiffCallback.resolve(paramName, originalStr) == EMPTY_LIST_OR_OBJ) continue;
            return false;
        }
        if (!paramNames.isEmpty()) {
            boolean matches = true;
            String specName = original.getSpecId().getName();
            ResolvedFeatureId fid = actual.getId();
            for (String name : paramNames) {
                String actualValue = actual.getConfigParam(name);
                if (fid != null && name.equals("module") && specName.equals("extension") && actualValue.equals(fid.getParams().get("extension"))) continue;
                matches = false;
            }
            if (!matches) {
                return false;
            }
        }
        return true;
    }

    private static Object resolve(String paramName, String provisionedValue) throws ProvisioningException {
        if (provisionedValue == null || provisionedValue.isEmpty() || provisionedValue.length() > 2 && provisionedValue.charAt(0) == '$' && provisionedValue.charAt(1) == '{') {
            return provisionedValue;
        }
        return WfFeatureDiffCallback.toJava(WfFeatureDiffCallback.toDmr(paramName, provisionedValue));
    }

    private static ModelNode toDmr(String paramName, String provisionedValue) throws ProvisioningException {
        try {
            return ModelNode.fromString((String)provisionedValue);
        }
        catch (Exception e) {
            ArgumentValueCallbackHandler handler = new ArgumentValueCallbackHandler();
            try {
                StateParser.parse((String)provisionedValue, (ParsingStateCallbackHandler)handler, (ParsingState)ArgumentValueInitialState.INSTANCE);
            }
            catch (CommandFormatException e1) {
                throw new ProvisioningException("Failed to parse parameter " + paramName + " '" + provisionedValue + "'", (Throwable)e1);
            }
            return handler.getResult();
        }
    }

    private static Object toJava(ModelNode node) {
        switch (node.getType()) {
            case LIST: {
                List list = node.asList();
                if (list.isEmpty()) {
                    return EMPTY_LIST_OR_OBJ;
                }
                int size = list.size();
                if (size == 1) {
                    return Collections.singletonList(WfFeatureDiffCallback.toJava((ModelNode)list.get(0)));
                }
                ArrayList<Object> o = new ArrayList<Object>(size);
                for (ModelNode item : list) {
                    o.add(WfFeatureDiffCallback.toJava(item));
                }
                return o;
            }
            case OBJECT: {
                List list = node.asPropertyList();
                if (list.isEmpty()) {
                    return EMPTY_LIST_OR_OBJ;
                }
                int size = list.size();
                if (size == 1) {
                    Property prop = (Property)list.get(0);
                    return Collections.singletonMap(prop.getName(), WfFeatureDiffCallback.toJava(prop.getValue()));
                }
                HashMap<String, Object> map = new HashMap<String, Object>(size);
                for (Property prop : list) {
                    map.put(prop.getName(), WfFeatureDiffCallback.toJava(prop.getValue()));
                }
                return map;
            }
            case PROPERTY: {
                Property prop = node.asProperty();
                return Collections.singletonMap(prop.getName(), WfFeatureDiffCallback.toJava(prop.getValue()));
            }
        }
        return node.asString();
    }
}

