/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class BoottimeAddStepHandler
extends AbstractBoottimeAddStepHandler
implements Registration {
    private final ResourceDescriptionResolver resolver;
    private final ResourceServiceHandler handler;
    private final List<Attribute> attributes = new LinkedList<Attribute>();

    public <E extends Enum<E>> BoottimeAddStepHandler(ResourceDescriptionResolver resolver, ResourceServiceHandler handler) {
        this.resolver = resolver;
        this.handler = handler;
    }

    public <E extends Enum<E>> BoottimeAddStepHandler addAttributes(Class<E> enumClass) {
        return this.addAttributes(EnumSet.allOf(enumClass));
    }

    public BoottimeAddStepHandler addAttributes(Attribute ... attributes) {
        return this.addAttributes(Arrays.asList(attributes));
    }

    public BoottimeAddStepHandler addAttributes(Collection<? extends Attribute> attributes) {
        this.attributes.addAll(attributes);
        return this;
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        for (Attribute attribute : this.attributes) {
            ((AttributeDefinition)attribute.getDefinition()).validateAndSet(operation, model);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.handler.installServices(context, resource.getModel());
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        try {
            this.handler.removeServices(context, resource.getModel());
        }
        catch (OperationFailedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder("add", this.resolver).withFlag(OperationEntry.Flag.RESTART_NONE);
        for (Attribute attribute : this.attributes) {
            builder.addParameter((AttributeDefinition)attribute.getDefinition());
        }
        registration.registerOperationHandler((OperationDefinition)builder.build(), (OperationStepHandler)this);
    }
}

