/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.concurrent;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.as.clustering.concurrent.ManagedExecutorService;

public class ManagedScheduledExecutorService
extends ManagedExecutorService
implements ScheduledExecutorService {
    private final List<Future<?>> futures = new LinkedList();
    private volatile boolean shutdown = false;
    private volatile boolean terminated = false;
    private final ScheduledExecutorService executor;

    public ManagedScheduledExecutorService(ScheduledExecutorService executor) {
        super(executor);
        this.executor = executor;
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown(true);
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean interrupt) {
        List<Future<?>> list = this.futures;
        synchronized (list) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            for (Future<?> future : this.futures) {
                if (future.isDone()) continue;
                future.cancel(interrupt);
            }
            if (!interrupt) {
                for (Future<?> future : this.futures) {
                    if (future.isDone()) continue;
                    try {
                        future.get();
                    }
                    catch (ExecutionException executionException) {
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.futures.clear();
            this.terminated = true;
            this.futures.notify();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.terminated) {
            return true;
        }
        List<Future<?>> list = this.futures;
        synchronized (list) {
            this.futures.wait(unit.toMillis(timeout));
        }
        return this.terminated;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executor.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executor.schedule(callable, delay, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        List<Future<?>> list = this.futures;
        synchronized (list) {
            if (this.shutdown) {
                throw new RejectedExecutionException();
            }
            ScheduledFuture<?> future = this.executor.scheduleAtFixedRate(command, initialDelay, period, unit);
            this.futures.add(future);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        List<Future<?>> list = this.futures;
        synchronized (list) {
            if (this.shutdown) {
                throw new RejectedExecutionException();
            }
            ScheduledFuture<?> future = this.executor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
            this.futures.add(future);
            return future;
        }
    }
}

