/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Collection;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.jboss.as.clustering.controller.AddIfAbsentStepHandler;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.CapabilityRegistration;
import org.jboss.as.clustering.controller.DescribedAddStepHandler;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.transform.InitialAttributeValueOperationContextAttachment;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformerOperationAttachment;
import org.jboss.dmr.ModelNode;

public class AddStepHandler
extends AbstractAddStepHandler
implements Registration<ManagementResourceRegistration>,
DescribedAddStepHandler {
    private final AddStepHandlerDescriptor descriptor;
    private final ResourceServiceHandler handler;
    private final OperationStepHandler writeAttributeHandler;

    public AddStepHandler(AddStepHandlerDescriptor descriptor) {
        this(descriptor, null);
    }

    public AddStepHandler(AddStepHandlerDescriptor descriptor, ResourceServiceHandler handler) {
        this(descriptor, handler, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(descriptor.getAttributes()){

            protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
                super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
                if (!context.isBooting()) {
                    TransformerOperationAttachment attachment = TransformerOperationAttachment.getOrCreate((OperationContext)context);
                    InitialAttributeValueOperationContextAttachment valuesAttachment = (InitialAttributeValueOperationContextAttachment)attachment.getAttachment(InitialAttributeValueOperationContextAttachment.INITIAL_VALUES_ATTACHMENT);
                    if (valuesAttachment == null) {
                        valuesAttachment = new InitialAttributeValueOperationContextAttachment();
                        attachment.attach(InitialAttributeValueOperationContextAttachment.INITIAL_VALUES_ATTACHMENT, (Object)valuesAttachment);
                    }
                    valuesAttachment.putIfAbsentInitialValue(Operations.getPathAddress(operation), attributeName, oldValue);
                }
            }
        });
    }

    AddStepHandler(AddStepHandlerDescriptor descriptor, ResourceServiceHandler handler, OperationStepHandler writeAttributeHandler) {
        super(descriptor.getAttributes());
        this.descriptor = descriptor;
        this.handler = handler;
        this.writeAttributeHandler = writeAttributeHandler;
    }

    @Override
    public AddStepHandlerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress parentAddress = address.getParent();
        PathElement path = address.getLastElement();
        OperationStepHandler parentHandler = context.getRootResourceRegistration().getOperationHandler(parentAddress, "add");
        if (parentHandler instanceof DescribedAddStepHandler) {
            AddStepHandlerDescriptor parentDescriptor = (AddStepHandlerDescriptor)((DescribedAddStepHandler)parentHandler).getDescriptor();
            if (parentDescriptor.getRequiredChildren().contains(path)) {
                if (context.readResourceFromRoot(parentAddress, false).hasChild(path)) {
                    context.addStep(Util.createRemoveOperation((PathAddress)address), context.getRootResourceRegistration().getOperationHandler(address, "remove"), OperationContext.Stage.MODEL);
                    context.addStep(operation, (OperationStepHandler)this, OperationContext.Stage.MODEL);
                    return;
                }
            } else {
                Optional<PathElement> singletonPathResult = parentDescriptor.getRequiredSingletonChildren().stream().filter(requiredPath -> requiredPath.getKey().equals(path.getKey()) && !requiredPath.getValue().equals(path.getValue())).findFirst();
                if (singletonPathResult.isPresent()) {
                    PathElement singletonPath = singletonPathResult.get();
                    if (context.readResourceFromRoot(parentAddress, false).hasChild(singletonPath)) {
                        PathAddress singletonAddress = parentAddress.append(new PathElement[]{singletonPath});
                        context.addStep(Util.createRemoveOperation((PathAddress)singletonAddress), context.getRootResourceRegistration().getOperationHandler(singletonAddress, "remove"), OperationContext.Stage.MODEL);
                        context.addStep(operation, (OperationStepHandler)this, OperationContext.Stage.MODEL);
                        return;
                    }
                }
            }
        }
        super.execute(context, operation);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        for (AttributeDefinition definition : this.descriptor.getExtraParameters()) {
            definition.validateOperation(operation);
        }
        super.populateModel(context, operation, resource);
        AddStepHandler.addRequiredChildren(context, this.descriptor.getRequiredChildren(), (parent, path) -> parent.hasChild(path));
        AddStepHandler.addRequiredChildren(context, this.descriptor.getRequiredSingletonChildren(), (parent, path) -> parent.hasChildren(path.getKey()));
    }

    private static void addRequiredChildren(OperationContext context, Collection<PathElement> paths, BiPredicate<Resource, PathElement> present) {
        for (PathElement path : paths) {
            context.addStep(Util.createAddOperation((PathAddress)context.getCurrentAddress().append(new PathElement[]{path})), (OperationStepHandler)new AddIfAbsentStepHandler(present), OperationContext.Stage.MODEL);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (this.handler != null) {
            this.handler.installServices(context, model);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        if (this.handler != null) {
            try {
                this.handler.removeServices(context, resource.getModel());
            }
            catch (OperationFailedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        this.descriptor.getCapabilities().forEach(capability -> context.registerCapability(capability.getRuntimeCapability(address)));
        ModelNode model = resource.getModel();
        this.attributes.stream().filter(attribute -> model.hasDefined(attribute.getName()) || attribute.hasCapabilityRequirements()).forEach(attribute -> attribute.addCapabilityRequirements(context, model.get(attribute.getName())));
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder("add", this.descriptor.getDescriptionResolver()).withFlag(OperationEntry.Flag.RESTART_NONE);
        this.descriptor.getAttributes().forEach(attribute -> builder.addParameter(attribute));
        this.descriptor.getExtraParameters().forEach(attribute -> builder.addParameter(attribute));
        registration.registerOperationHandler((OperationDefinition)builder.build(), (OperationStepHandler)this);
        this.descriptor.getAttributes().forEach(attribute -> registration.registerReadWriteAttribute(attribute, null, this.writeAttributeHandler));
        new CapabilityRegistration(this.descriptor.getCapabilities()).register(registration);
    }
}

