/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jboss.as.clustering.controller.Executable;
import org.jboss.as.clustering.controller.Executor;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class ExecutionHandler<C, E extends Executable<C>>
extends AbstractRuntimeOnlyHandler {
    private final Map<String, E> executables = new HashMap<String, E>();
    private final Executor<C, E> executor;
    private final Function<ModelNode, String> nameExtractor;

    public ExecutionHandler(Executor<C, E> executor, Collection<? extends E> executables, Function<E, String> nameFactory, Function<ModelNode, String> nameExtractor) {
        this.executor = executor;
        for (Executable executable : executables) {
            this.executables.put(nameFactory.apply(executable), executable);
        }
        this.nameExtractor = nameExtractor;
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) {
        String name = this.nameExtractor.apply(operation);
        Executable executable = (Executable)this.executables.get(name);
        try {
            ModelNode result = this.executor.execute(context, executable);
            if (result != null) {
                context.getResult().set(result);
            }
        }
        catch (OperationFailedException e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
        context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }
}

