/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public abstract class AbstractModulesServiceConfigurator<T>
implements ResourceServiceConfigurator,
Function<List<Module>, T> {
    private final RuntimeCapability<Void> capability;
    private final ResourceModelResolver<List<String>> resolver;

    AbstractModulesServiceConfigurator(RuntimeCapability<Void> capability, ResourceModelResolver<List<String>> resolver) {
        this.capability = capability;
        this.resolver = resolver;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final List moduleIdentifiers = (List)this.resolver.resolve(context, model);
        final ServiceDependency loader = ServiceDependency.on((ServiceName)Services.JBOSS_SERVICE_MODULE_LOADER);
        Supplier<List<Module>> modules = new Supplier<List<Module>>(){

            @Override
            public List<Module> get() {
                return moduleIdentifiers.stream().map(this::load).collect(Collectors.toUnmodifiableList());
            }

            private Module load(String identifier) {
                try {
                    return ((ModuleLoader)loader.get()).loadModule(identifier);
                }
                catch (ModuleLoadException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(this.capability, (Function)this, (Supplier)modules).requires((Consumer)loader)).asPassive()).build();
    }
}

