/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossExecutors;

public class CachedThreadPoolExecutorService
implements Service<ExecutorService> {
    private final ThreadFactory threadFactory;
    private volatile ExecutorService executor;

    public static ServiceBuilder<ExecutorService> build(ServiceTarget target, ServiceName name, ThreadFactory factory) {
        return AsynchronousService.addService(target, name, new CachedThreadPoolExecutorService(factory), false, true);
    }

    private CachedThreadPoolExecutorService(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public ExecutorService getValue() {
        return JBossExecutors.protectedExecutorService((Executor)this.executor);
    }

    public void start(StartContext context) {
        this.executor = Executors.newCachedThreadPool(this.threadFactory);
    }

    public void stop(StopContext context) {
        this.executor.shutdown();
        this.executor = null;
    }
}

