/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.as.clustering.concurrent.ManagedExecutorServiceTest;
import org.jboss.as.clustering.concurrent.ManagedScheduledExecutorService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ManagedScheduledExecutorTest
extends ManagedExecutorServiceTest {
    private final ScheduledExecutorService executor;
    private final ScheduledExecutorService subject;

    public ManagedScheduledExecutorTest() {
        this((ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class));
    }

    private ManagedScheduledExecutorTest(ScheduledExecutorService executor) {
        this(executor, (ScheduledExecutorService)new ManagedScheduledExecutorService(executor));
    }

    private ManagedScheduledExecutorTest(ScheduledExecutorService executor, ScheduledExecutorService subject) {
        super(executor, subject);
        this.executor = executor;
        this.subject = subject;
    }

    @Override
    public void isShutdown() {
        boolean result = this.subject.isShutdown();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.executor});
        Assert.assertFalse((boolean)result);
    }

    @Override
    public void isTerminated() {
        boolean result = this.subject.isTerminated();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.executor});
        Assert.assertFalse((boolean)result);
    }

    @Override
    public void awaitTermination() throws InterruptedException {
        boolean result = this.subject.awaitTermination(1L, TimeUnit.SECONDS);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.executor});
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void scheduleCallable() {
        ScheduledFuture expected = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        ManagedExecutorServiceTest.Task task = new ManagedExecutorServiceTest.Task();
        long delay = 10L;
        TimeUnit unit = TimeUnit.SECONDS;
        Mockito.when(this.executor.schedule(task, delay, unit)).thenReturn((Object)expected);
        ScheduledFuture<Object> result = this.subject.schedule(task, delay, unit);
        Assert.assertSame((Object)expected, result);
    }

    @Test
    public void scheduleAtFixedRate() {
        ScheduledFuture expected = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        long delay = 10L;
        long period = 20L;
        TimeUnit unit = TimeUnit.SECONDS;
        Mockito.when(this.executor.scheduleAtFixedRate(task, delay, period, unit)).thenReturn((Object)expected);
        ScheduledFuture<?> result = this.subject.scheduleAtFixedRate(task, delay, period, unit);
        Assert.assertSame((Object)expected, result);
    }

    @Test
    public void scheduleWithFixedDelay() {
        ScheduledFuture expected = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Runnable task = (Runnable)Mockito.mock(Runnable.class);
        long delay = 10L;
        long period = 20L;
        TimeUnit unit = TimeUnit.SECONDS;
        Mockito.when(this.executor.scheduleWithFixedDelay(task, delay, period, unit)).thenReturn((Object)expected);
        ScheduledFuture<?> result = this.subject.scheduleWithFixedDelay(task, delay, period, unit);
        Assert.assertSame((Object)expected, result);
    }
}

