/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.concurrent;

import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ee.cache.concurrent.StampedLockServiceExecutor;
import org.wildfly.clustering.ee.concurrent.ServiceExecutor;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public class StampedLockServiceExecutorTestCase {
    @Test
    public void testExecuteRunnable() {
        StampedLockServiceExecutor executor = new StampedLockServiceExecutor();
        Runnable executeTask = (Runnable)Mockito.mock(Runnable.class);
        executor.execute(executeTask);
        ((Runnable)Mockito.verify((Object)executeTask)).run();
        Mockito.reset((Object[])new Runnable[]{executeTask});
        Runnable closeTask = (Runnable)Mockito.mock(Runnable.class);
        executor.close(closeTask);
        ((Runnable)Mockito.verify((Object)closeTask)).run();
        Mockito.reset((Object[])new Runnable[]{closeTask});
        executor.close(closeTask);
        ((Runnable)Mockito.verify((Object)closeTask, (VerificationMode)Mockito.never())).run();
        executor.execute(executeTask);
        ((Runnable)Mockito.verify((Object)executeTask, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testExecuteExceptionRunnable() throws Exception {
        StampedLockServiceExecutor executor = new StampedLockServiceExecutor();
        ExceptionRunnable executeTask = (ExceptionRunnable)Mockito.mock(ExceptionRunnable.class);
        executor.execute(executeTask);
        ((ExceptionRunnable)Mockito.verify((Object)executeTask)).run();
        Mockito.reset((Object[])new ExceptionRunnable[]{executeTask});
        ((ExceptionRunnable)Mockito.doThrow((Throwable[])new Throwable[]{new Exception()}).when((Object)executeTask)).run();
        try {
            executor.execute(executeTask);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e);
        }
        Mockito.reset((Object[])new ExceptionRunnable[]{executeTask});
        Runnable closeTask = (Runnable)Mockito.mock(Runnable.class);
        executor.close(closeTask);
        ((Runnable)Mockito.verify((Object)closeTask)).run();
        Mockito.reset((Object[])new Runnable[]{closeTask});
        executor.close(closeTask);
        ((Runnable)Mockito.verify((Object)closeTask, (VerificationMode)Mockito.never())).run();
        executor.execute(executeTask);
        ((ExceptionRunnable)Mockito.verify((Object)executeTask, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testExecuteSupplier() {
        StampedLockServiceExecutor executor = new StampedLockServiceExecutor();
        Object expected = new Object();
        Supplier executeTask = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when(executeTask.get()).thenReturn(expected);
        Optional result = executor.execute(executeTask);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertSame((Object)expected, result.get());
        Mockito.reset((Object[])new Supplier[]{executeTask});
        Runnable closeTask = (Runnable)Mockito.mock(Runnable.class);
        executor.close(closeTask);
        ((Runnable)Mockito.verify((Object)closeTask)).run();
        Mockito.reset((Object[])new Runnable[]{closeTask});
        executor.close(closeTask);
        ((Runnable)Mockito.verify((Object)closeTask, (VerificationMode)Mockito.never())).run();
        result = executor.execute(executeTask);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testExecuteExceptionSupplier() throws Exception {
        StampedLockServiceExecutor executor = new StampedLockServiceExecutor();
        Object expected = new Object();
        ExceptionSupplier executeTask = (ExceptionSupplier)Mockito.mock(ExceptionSupplier.class);
        Mockito.when((Object)executeTask.get()).thenReturn(expected);
        Optional result = executor.execute(executeTask);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertSame((Object)expected, result.get());
        Mockito.reset((Object[])new ExceptionSupplier[]{executeTask});
        ((ExceptionSupplier)Mockito.doThrow((Throwable[])new Throwable[]{new Exception()}).when((Object)executeTask)).get();
        try {
            executor.execute(executeTask);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e);
        }
        Mockito.reset((Object[])new ExceptionSupplier[]{executeTask});
        Runnable closeTask = (Runnable)Mockito.mock(Runnable.class);
        executor.close(closeTask);
        ((Runnable)Mockito.verify((Object)closeTask)).run();
        Mockito.reset((Object[])new Runnable[]{closeTask});
        executor.close(closeTask);
        ((Runnable)Mockito.verify((Object)closeTask, (VerificationMode)Mockito.never())).run();
        result = executor.execute(executeTask);
        Assert.assertFalse((boolean)result.isPresent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrent() throws InterruptedException, ExecutionException {
        StampedLockServiceExecutor executor = new StampedLockServiceExecutor();
        ExecutorService service = Executors.newFixedThreadPool(2);
        try {
            CountDownLatch executeLatch = new CountDownLatch(1);
            CountDownLatch stopLatch = new CountDownLatch(1);
            Runnable executeTask = () -> {
                try {
                    executeLatch.countDown();
                    stopLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            };
            Future<?> executeFuture = service.submit(() -> StampedLockServiceExecutorTestCase.lambda$concurrent$1((ServiceExecutor)executor, executeTask));
            executeLatch.await();
            Runnable closeTask = (Runnable)Mockito.mock(Runnable.class);
            Future<?> closeFuture = service.submit(() -> StampedLockServiceExecutorTestCase.lambda$concurrent$2((ServiceExecutor)executor, closeTask));
            Thread.yield();
            ((Runnable)Mockito.verify((Object)closeTask, (VerificationMode)Mockito.never())).run();
            stopLatch.countDown();
            executeFuture.get();
            closeFuture.get();
            ((Runnable)Mockito.verify((Object)closeTask)).run();
        }
        finally {
            service.shutdownNow();
        }
    }

    private static /* synthetic */ void lambda$concurrent$2(ServiceExecutor executor, Runnable closeTask) {
        executor.close(closeTask);
    }

    private static /* synthetic */ void lambda$concurrent$1(ServiceExecutor executor, Runnable executeTask) {
        executor.execute(executeTask);
    }
}

