/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.function;

import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ee.cache.function.ConcurrentMapPutFunction;
import org.wildfly.clustering.ee.cache.function.ConcurrentMapRemoveFunction;
import org.wildfly.clustering.ee.cache.function.ConcurrentSetAddFunction;
import org.wildfly.clustering.ee.cache.function.ConcurrentSetRemoveFunction;
import org.wildfly.clustering.ee.cache.function.CopyOnWriteMapPutFunction;
import org.wildfly.clustering.ee.cache.function.CopyOnWriteMapRemoveFunction;
import org.wildfly.clustering.ee.cache.function.CopyOnWriteSetAddFunction;
import org.wildfly.clustering.ee.cache.function.CopyOnWriteSetRemoveFunction;

public class FunctionTestCase {
    @Test
    public void copyOnWriteSet() {
        Set result = (Set)new CopyOnWriteSetAddFunction((Object)"foo").apply(null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.contains("foo"));
        Set result2 = (Set)new CopyOnWriteSetAddFunction((Object)"bar").apply(null, (Object)result);
        Assert.assertNotNull((Object)result2);
        Assert.assertNotSame((Object)result, (Object)result2);
        Assert.assertTrue((boolean)result2.contains("foo"));
        Assert.assertTrue((boolean)result2.contains("bar"));
        Set result3 = (Set)new CopyOnWriteSetRemoveFunction((Object)"foo").apply(null, (Object)result2);
        Assert.assertNotNull((Object)result3);
        Assert.assertNotSame((Object)result2, (Object)result3);
        Assert.assertFalse((boolean)result3.contains("foo"));
        Assert.assertTrue((boolean)result3.contains("bar"));
        Set result4 = (Set)new CopyOnWriteSetRemoveFunction((Object)"bar").apply(null, (Object)result3);
        Assert.assertNull((Object)result4);
    }

    @Test
    public void concurrentSet() {
        Set result = (Set)new ConcurrentSetAddFunction((Object)"foo").apply(null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.contains("foo"));
        Set result2 = (Set)new ConcurrentSetAddFunction((Object)"bar").apply(null, (Object)result);
        Assert.assertNotNull((Object)result2);
        Assert.assertSame((Object)result, (Object)result2);
        Assert.assertTrue((boolean)result2.contains("foo"));
        Assert.assertTrue((boolean)result2.contains("bar"));
        Set result3 = (Set)new ConcurrentSetRemoveFunction((Object)"foo").apply(null, (Object)result2);
        Assert.assertNotNull((Object)result3);
        Assert.assertSame((Object)result2, (Object)result3);
        Assert.assertFalse((boolean)result3.contains("foo"));
        Assert.assertTrue((boolean)result3.contains("bar"));
        Set result4 = (Set)new ConcurrentSetRemoveFunction((Object)"bar").apply(null, (Object)result3);
        Assert.assertNull((Object)result4);
    }

    @Test
    public void copyOnWriteMap() {
        Map result = (Map)new CopyOnWriteMapPutFunction((Object)"foo", (Object)"a").apply(null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.containsKey("foo"));
        Map result2 = (Map)new CopyOnWriteMapPutFunction((Object)"bar", (Object)"b").apply(null, (Object)result);
        Assert.assertNotNull((Object)result2);
        Assert.assertNotSame((Object)result, (Object)result2);
        Assert.assertTrue((boolean)result2.containsKey("foo"));
        Assert.assertTrue((boolean)result2.containsKey("bar"));
        Map result3 = (Map)new CopyOnWriteMapRemoveFunction((Object)"foo").apply(null, (Object)result2);
        Assert.assertNotNull((Object)result3);
        Assert.assertNotSame((Object)result2, (Object)result3);
        Assert.assertFalse((boolean)result3.containsKey("foo"));
        Assert.assertTrue((boolean)result3.containsKey("bar"));
        Map result4 = (Map)new CopyOnWriteMapRemoveFunction((Object)"bar").apply(null, (Object)result3);
        Assert.assertNull((Object)result4);
    }

    @Test
    public void concurrentMap() {
        Map result = (Map)new ConcurrentMapPutFunction((Object)"foo", (Object)"a").apply(null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.containsKey("foo"));
        Map result2 = (Map)new ConcurrentMapPutFunction((Object)"bar", (Object)"b").apply(null, (Object)result);
        Assert.assertNotNull((Object)result2);
        Assert.assertSame((Object)result, (Object)result2);
        Assert.assertTrue((boolean)result2.containsKey("foo"));
        Assert.assertTrue((boolean)result2.containsKey("bar"));
        Map result3 = (Map)new ConcurrentMapRemoveFunction((Object)"foo").apply(null, (Object)result2);
        Assert.assertNotNull((Object)result3);
        Assert.assertSame((Object)result2, (Object)result3);
        Assert.assertFalse((boolean)result3.containsKey("foo"));
        Assert.assertTrue((boolean)result3.containsKey("bar"));
        Map result4 = (Map)new ConcurrentMapRemoveFunction((Object)"bar").apply(null, (Object)result3);
        Assert.assertNull((Object)result4);
    }
}

