/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.scheduler;

import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.ee.cache.scheduler.LocalScheduler;
import org.wildfly.clustering.ee.cache.scheduler.ScheduledEntries;

public class LocalSchedulerTestCase {
    @Test
    public void successfulTask() throws InterruptedException {
        ScheduledEntries entries = (ScheduledEntries)Mockito.mock(ScheduledEntries.class);
        Predicate task = (Predicate)Mockito.mock(Predicate.class);
        AbstractMap.SimpleImmutableEntry<UUID, Instant> entry = new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), Instant.now());
        ArrayList<AbstractMap.SimpleImmutableEntry<UUID, Instant>> entryList = new ArrayList<AbstractMap.SimpleImmutableEntry<UUID, Instant>>(1);
        entryList.add(entry);
        try (LocalScheduler scheduler = new LocalScheduler(entries, task, Duration.ZERO);){
            Mockito.when((Object)entries.peek()).thenReturn(entry, null);
            ((ScheduledEntries)Mockito.doAnswer(invocation -> entryList.iterator()).when((Object)entries)).iterator();
            Mockito.when((Object)task.test((UUID)entry.getKey())).thenReturn((Object)true);
            scheduler.schedule((Object)((UUID)entry.getKey()), (Object)((Instant)entry.getValue()));
            ((ScheduledEntries)Mockito.verify((Object)entries)).add((Object)((UUID)entry.getKey()), (Object)((Instant)entry.getValue()));
            Thread.sleep(500L);
            Assert.assertTrue((boolean)entryList.isEmpty());
        }
    }

    @Test
    public void failingTask() throws InterruptedException {
        ScheduledEntries entries = (ScheduledEntries)Mockito.mock(ScheduledEntries.class);
        Predicate task = (Predicate)Mockito.mock(Predicate.class);
        AbstractMap.SimpleImmutableEntry<UUID, Instant> entry = new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), Instant.now());
        ArrayList<AbstractMap.SimpleImmutableEntry<UUID, Instant>> entryList = new ArrayList<AbstractMap.SimpleImmutableEntry<UUID, Instant>>(1);
        entryList.add(entry);
        try (LocalScheduler scheduler = new LocalScheduler(entries, task, Duration.ZERO);){
            Mockito.when((Object)entries.peek()).thenReturn(entry, null);
            ((ScheduledEntries)Mockito.doAnswer(invocation -> entryList.iterator()).when((Object)entries)).iterator();
            Mockito.when((Object)task.test((UUID)entry.getKey())).thenReturn((Object)false);
            scheduler.schedule((Object)((UUID)entry.getKey()), (Object)((Instant)entry.getValue()));
            ((ScheduledEntries)Mockito.verify((Object)entries)).add((Object)((UUID)entry.getKey()), (Object)((Instant)entry.getValue()));
            Thread.sleep(500L);
            Assert.assertFalse((boolean)entryList.isEmpty());
        }
    }

    @Test
    public void retryUntilSuccessfulTask() throws InterruptedException {
        ScheduledEntries entries = (ScheduledEntries)Mockito.mock(ScheduledEntries.class);
        Predicate task = (Predicate)Mockito.mock(Predicate.class);
        AbstractMap.SimpleImmutableEntry<UUID, Instant> entry = new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), Instant.now());
        ArrayList<AbstractMap.SimpleImmutableEntry<UUID, Instant>> entryList = new ArrayList<AbstractMap.SimpleImmutableEntry<UUID, Instant>>(1);
        entryList.add(entry);
        try (LocalScheduler scheduler = new LocalScheduler(entries, task, Duration.ZERO);){
            Mockito.when((Object)entries.peek()).thenReturn(entry, (Object[])new Map.Entry[]{entry, null});
            ((ScheduledEntries)Mockito.doAnswer(invocation -> entryList.iterator()).when((Object)entries)).iterator();
            Mockito.when((Object)task.test((UUID)entry.getKey())).thenReturn((Object)false, (Object[])new Boolean[]{true});
            scheduler.schedule((Object)((UUID)entry.getKey()), (Object)((Instant)entry.getValue()));
            ((ScheduledEntries)Mockito.verify((Object)entries)).add((Object)((UUID)entry.getKey()), (Object)((Instant)entry.getValue()));
            Thread.sleep(500L);
            Assert.assertTrue((boolean)entryList.isEmpty());
        }
    }

    @Test
    public void cancel() {
        ScheduledEntries entries = (ScheduledEntries)Mockito.mock(ScheduledEntries.class);
        Predicate task = (Predicate)Mockito.mock(Predicate.class);
        AbstractMap.SimpleImmutableEntry<UUID, Instant> entry = new AbstractMap.SimpleImmutableEntry<UUID, Instant>(UUID.randomUUID(), Instant.now());
        try (LocalScheduler scheduler = new LocalScheduler(entries, task, Duration.ZERO);){
            Mockito.when((Object)entries.peek()).thenReturn(entry);
            scheduler.cancel((Object)((UUID)entry.getKey()));
            ((ScheduledEntries)Mockito.verify((Object)entries)).remove((Object)((UUID)entry.getKey()));
        }
    }
}

