/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class CollectionImmutability
implements Predicate<Object> {
    private final List<Class<?>> unmodifiableClasses = Arrays.asList(Collections.singleton(null).getClass(), Collections.singletonList(null).getClass(), Collections.singletonMap(null, null).getClass(), Collections.unmodifiableCollection(Collections.emptyList()).getClass(), Collections.unmodifiableList(Collections.emptyList()).getClass(), Collections.unmodifiableMap(Collections.emptyMap()).getClass(), Collections.unmodifiableNavigableMap(Collections.emptyNavigableMap()).getClass(), Collections.unmodifiableNavigableSet(Collections.emptyNavigableSet()).getClass(), Collections.unmodifiableSet(Collections.emptySet()).getClass(), Collections.unmodifiableSortedMap(Collections.emptySortedMap()).getClass(), Collections.unmodifiableSortedSet(Collections.emptySortedSet()).getClass());
    private final Predicate<Object> elementImmutability;

    public CollectionImmutability(Predicate<Object> elementImmutability) {
        this.elementImmutability = elementImmutability;
    }

    @Override
    public boolean test(Object object) {
        for (Class<?> unmodifiableClass : this.unmodifiableClasses) {
            if (!unmodifiableClass.isInstance(object)) continue;
            if (object instanceof Set) {
                return true;
            }
            Collection collection = object instanceof Map ? ((Map)object).values() : (Collection)object;
            for (Object element : collection) {
                if (this.elementImmutability.test(element)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

