/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.retry;

import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.ee.retry.RetryingInvoker;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public class RetryingInvokerTestCase {
    @Test
    public void testSupplier() throws Exception {
        Throwable[] exceptions = new Exception[3];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptions[i] = new Exception();
        }
        Object expected = new Object();
        ExceptionSupplier action = (ExceptionSupplier)Mockito.mock(ExceptionSupplier.class);
        RetryingInvoker invoker = new RetryingInvoker(new Duration[]{Duration.ZERO, Duration.ofMillis(1L)});
        Mockito.when((Object)action.get()).thenReturn(expected);
        Object result = invoker.invoke(action);
        Assert.assertSame((Object)expected, (Object)result);
        Mockito.when((Object)action.get()).thenThrow(new Throwable[]{exceptions[0]}).thenReturn(expected);
        result = invoker.invoke(action);
        Assert.assertSame((Object)expected, (Object)result);
        Mockito.when((Object)action.get()).thenThrow(new Throwable[]{exceptions[0], exceptions[1]}).thenReturn(expected);
        result = invoker.invoke(action);
        Assert.assertSame((Object)expected, (Object)result);
        Mockito.when((Object)action.get()).thenThrow(exceptions).thenReturn(expected);
        try {
            result = invoker.invoke(action);
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertSame((Object)exceptions[2], (Object)e);
        }
    }

    @Test
    public void testRunnable() throws Exception {
        Throwable[] exceptions = new Exception[3];
        for (int i = 0; i < exceptions.length; ++i) {
            exceptions[i] = new Exception();
        }
        ExceptionRunnable action = (ExceptionRunnable)Mockito.mock(ExceptionRunnable.class);
        ((ExceptionRunnable)Mockito.doNothing().when((Object)action)).run();
        RetryingInvoker invoker = new RetryingInvoker(new Duration[]{Duration.ZERO, Duration.ZERO});
        invoker.invoke(action);
        ((ExceptionRunnable)Mockito.doThrow((Throwable[])new Throwable[]{exceptions[0]}).doNothing().when((Object)action)).run();
        invoker.invoke(action);
        ((ExceptionRunnable)Mockito.doThrow((Throwable[])new Throwable[]{exceptions[0], exceptions[1]}).doNothing().when((Object)action)).run();
        invoker.invoke(action);
        ((ExceptionRunnable)Mockito.doThrow((Throwable[])exceptions).doNothing().when((Object)action)).run();
        try {
            invoker.invoke(action);
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertSame((Object)exceptions[2], (Object)e);
        }
    }
}

