/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.immutable;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.FileSystems;
import java.security.AllPermission;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.Immutable;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.immutable.CompositeImmutability;
import org.wildfly.clustering.ee.immutable.DefaultImmutability;

public class DefaultImmutabilityTestCase {
    @Test
    public void test() throws Exception {
        this.test((Immutability)new CompositeImmutability(EnumSet.allOf(DefaultImmutability.class)));
    }

    protected void test(Immutability immutability) throws Exception {
        Assert.assertFalse((boolean)immutability.test(new Object()));
        Assert.assertFalse((boolean)immutability.test((Object)new Date()));
        Assert.assertFalse((boolean)immutability.test((Object)new AtomicInteger()));
        Assert.assertFalse((boolean)immutability.test((Object)new AtomicLong()));
        Assert.assertTrue((boolean)immutability.test(null));
        Assert.assertTrue((boolean)immutability.test(Collections.emptyEnumeration()));
        Assert.assertTrue((boolean)immutability.test(Collections.emptyIterator()));
        Assert.assertTrue((boolean)immutability.test(Collections.emptyList()));
        Assert.assertTrue((boolean)immutability.test(Collections.emptyListIterator()));
        Assert.assertTrue((boolean)immutability.test(Collections.emptyMap()));
        Assert.assertTrue((boolean)immutability.test(Collections.emptyNavigableMap()));
        Assert.assertTrue((boolean)immutability.test(Collections.emptyNavigableSet()));
        Assert.assertTrue((boolean)immutability.test(Collections.emptySet()));
        Assert.assertTrue((boolean)immutability.test(Collections.emptySortedMap()));
        Assert.assertTrue((boolean)immutability.test(Collections.emptySortedSet()));
        Assert.assertTrue((boolean)immutability.test((Object)Boolean.TRUE));
        Assert.assertTrue((boolean)immutability.test((Object)Character.valueOf('a')));
        Assert.assertTrue((boolean)immutability.test(this.getClass()));
        Assert.assertTrue((boolean)immutability.test((Object)Currency.getInstance(Locale.US)));
        Assert.assertTrue((boolean)immutability.test((Object)Locale.getDefault()));
        Assert.assertTrue((boolean)immutability.test((Object)Integer.valueOf(1).byteValue()));
        Assert.assertTrue((boolean)immutability.test((Object)Integer.valueOf(1).shortValue()));
        Assert.assertTrue((boolean)immutability.test((Object)1));
        Assert.assertTrue((boolean)immutability.test((Object)1L));
        Assert.assertTrue((boolean)immutability.test((Object)Float.valueOf(1.0f)));
        Assert.assertTrue((boolean)immutability.test((Object)1.0));
        Assert.assertTrue((boolean)immutability.test((Object)BigInteger.valueOf(1L)));
        Assert.assertTrue((boolean)immutability.test((Object)BigDecimal.valueOf(1L)));
        Assert.assertTrue((boolean)immutability.test((Object)InetAddress.getLocalHost()));
        Assert.assertTrue((boolean)immutability.test((Object)new InetSocketAddress(InetAddress.getLocalHost(), 80)));
        Assert.assertTrue((boolean)immutability.test((Object)MathContext.UNLIMITED));
        Assert.assertTrue((boolean)immutability.test((Object)"test"));
        Assert.assertTrue((boolean)immutability.test((Object)TimeZone.getDefault()));
        Assert.assertTrue((boolean)immutability.test((Object)UUID.randomUUID()));
        Assert.assertTrue((boolean)immutability.test((Object)TimeUnit.DAYS));
        File file = new File(System.getProperty("user.home"));
        Assert.assertTrue((boolean)immutability.test((Object)file));
        Assert.assertTrue((boolean)immutability.test((Object)file.toURI()));
        Assert.assertTrue((boolean)immutability.test((Object)file.toURI().toURL()));
        Assert.assertTrue((boolean)immutability.test((Object)FileSystems.getDefault().getRootDirectories().iterator().next()));
        Assert.assertTrue((boolean)immutability.test((Object)new AllPermission()));
        Assert.assertTrue((boolean)immutability.test((Object)DateTimeFormatter.BASIC_ISO_DATE));
        Assert.assertTrue((boolean)immutability.test((Object)DecimalStyle.STANDARD));
        Assert.assertTrue((boolean)immutability.test((Object)Duration.ZERO));
        Assert.assertTrue((boolean)immutability.test((Object)Instant.now()));
        Assert.assertTrue((boolean)immutability.test((Object)LocalDate.now()));
        Assert.assertTrue((boolean)immutability.test((Object)LocalDateTime.now()));
        Assert.assertTrue((boolean)immutability.test((Object)LocalTime.now()));
        Assert.assertTrue((boolean)immutability.test((Object)MonthDay.now()));
        Assert.assertTrue((boolean)immutability.test((Object)Period.ZERO));
        Assert.assertTrue((boolean)immutability.test((Object)ValueRange.of(0L, 10L)));
        Assert.assertTrue((boolean)immutability.test((Object)WeekFields.ISO));
        Assert.assertTrue((boolean)immutability.test((Object)Year.now()));
        Assert.assertTrue((boolean)immutability.test((Object)YearMonth.now()));
        Assert.assertTrue((boolean)immutability.test((Object)ZoneOffset.UTC));
        Assert.assertTrue((boolean)immutability.test((Object)ZoneRules.of(ZoneOffset.UTC).nextTransition(Instant.now())));
        Assert.assertTrue((boolean)immutability.test((Object)ZoneOffsetTransitionRule.of(Month.JANUARY, 1, DayOfWeek.SUNDAY, LocalTime.MIDNIGHT, true, ZoneOffsetTransitionRule.TimeDefinition.STANDARD, ZoneOffset.UTC, ZoneOffset.ofHours(1), ZoneOffset.ofHours(2))));
        Assert.assertTrue((boolean)immutability.test((Object)ZoneRules.of(ZoneOffset.UTC)));
        Assert.assertTrue((boolean)immutability.test((Object)ZonedDateTime.now()));
        Assert.assertTrue((boolean)immutability.test((Object)new JCIPImmutableObject()));
        Assert.assertTrue((boolean)immutability.test(Collections.singleton("1")));
        Assert.assertTrue((boolean)immutability.test(Collections.singletonList("1")));
        Assert.assertTrue((boolean)immutability.test(Collections.singletonMap("1", "2")));
        Assert.assertTrue((boolean)immutability.test(Collections.singleton(new JCIPImmutableObject())));
        Assert.assertTrue((boolean)immutability.test(Collections.singletonList(new JCIPImmutableObject())));
        Assert.assertTrue((boolean)immutability.test(Collections.singletonMap("1", new JCIPImmutableObject())));
        Assert.assertTrue((boolean)immutability.test(new AbstractMap.SimpleImmutableEntry<String, JCIPImmutableObject>("1", new JCIPImmutableObject())));
        Assert.assertTrue((boolean)immutability.test(Collections.unmodifiableCollection(Arrays.asList("1", "2"))));
        Assert.assertTrue((boolean)immutability.test(Collections.unmodifiableList(Arrays.asList("1", "2"))));
        Assert.assertTrue((boolean)immutability.test(Collections.unmodifiableMap(Collections.singletonMap("1", "2"))));
        Assert.assertTrue((boolean)immutability.test(Collections.unmodifiableNavigableMap(new TreeMap<String, String>(Collections.singletonMap("1", "2")))));
        Assert.assertTrue((boolean)immutability.test(Collections.unmodifiableNavigableSet(new TreeSet<String>(Collections.singleton("1")))));
        Assert.assertTrue((boolean)immutability.test(Collections.unmodifiableSet(Collections.singleton("1"))));
        Assert.assertTrue((boolean)immutability.test(Collections.unmodifiableSortedMap(new TreeMap<String, String>(Collections.singletonMap("1", "2")))));
        Assert.assertTrue((boolean)immutability.test(Collections.unmodifiableSortedSet(new TreeSet<String>(Collections.singleton("1")))));
        Assert.assertTrue((boolean)immutability.test(List.of()));
        Assert.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1))));
        Assert.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2))));
        Assert.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))));
        Assert.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4))));
        Assert.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5))));
        Assert.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6))));
        Assert.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7))));
        Assert.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8))));
        Assert.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9))));
        Assert.assertTrue((boolean)immutability.test(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(10))));
        Assert.assertTrue((boolean)immutability.test(List.of(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)));
        Assert.assertTrue((boolean)immutability.test(Set.of()));
        Assert.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1))));
        Assert.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2))));
        Assert.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3))));
        Assert.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4))));
        Assert.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5))));
        Assert.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6))));
        Assert.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7))));
        Assert.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8))));
        Assert.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9))));
        Assert.assertTrue((boolean)immutability.test(Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(10))));
        Assert.assertTrue((boolean)immutability.test(Set.of(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)));
        Assert.assertTrue((boolean)immutability.test(Map.of()));
        Assert.assertTrue((boolean)immutability.test(Map.of(1, "1")));
        Assert.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2")));
        Assert.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3")));
        Assert.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4")));
        Assert.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4", 5, "5")));
        Assert.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6")));
        Assert.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7")));
        Assert.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7", 8, "8")));
        Assert.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7", 8, "8", 9, "9")));
        Assert.assertTrue((boolean)immutability.test(Map.of(1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7", 8, "8", 9, "9", 10, "10")));
        Assert.assertTrue((boolean)immutability.test(Map.ofEntries(new Map.Entry[0])));
        Assert.assertTrue((boolean)immutability.test(Map.ofEntries(Map.entry(1, "1"))));
        Assert.assertTrue((boolean)immutability.test(Map.ofEntries(Map.entry(1, "1"), Map.entry(2, "2"))));
        AtomicInteger mutableObject = new AtomicInteger();
        Assert.assertFalse((boolean)immutability.test(Collections.singletonList(mutableObject)));
        Assert.assertFalse((boolean)immutability.test(Collections.singletonMap("1", mutableObject)));
        Assert.assertFalse((boolean)immutability.test(new AbstractMap.SimpleImmutableEntry<String, AtomicInteger>("1", mutableObject)));
    }

    @Immutable
    static class JCIPImmutableObject {
        JCIPImmutableObject() {
        }
    }
}

