/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.wildfly.clustering.ejb.bean.BeanExpiration;
import org.wildfly.clustering.ejb.bean.BeanMetaData;
import org.wildfly.clustering.ejb.cache.bean.BeanAccessMetaData;
import org.wildfly.clustering.ejb.cache.bean.BeanCreationMetaData;
import org.wildfly.clustering.ejb.cache.bean.CompositeImmutableBeanMetaData;

public class CompositeBeanMetaData<K>
extends CompositeImmutableBeanMetaData<K>
implements BeanMetaData<K> {
    private final BeanCreationMetaData<K> creationMetaData;
    private final BeanAccessMetaData accessMetaData;

    public CompositeBeanMetaData(BeanCreationMetaData<K> creationMetaData, BeanAccessMetaData accessMetaData, BeanExpiration expiration) {
        super(creationMetaData, accessMetaData, expiration);
        this.creationMetaData = creationMetaData;
        this.accessMetaData = accessMetaData;
    }

    public void setLastAccessTime(Instant lastAccessedTime) {
        Duration duration = Duration.between(this.creationMetaData.getCreationTime(), lastAccessedTime);
        this.accessMetaData.setLastAccessDuration(duration.getNano() == 0 ? duration : duration.truncatedTo(ChronoUnit.MILLIS).plusMillis(1L));
    }
}

