/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.time.Duration;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ejb.cache.timer.RemappableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataEntry;
import org.wildfly.clustering.ejb.timer.TimerConfiguration;

public abstract class AbstractTimerMetaDataEntryTestCase<E extends RemappableTimerMetaDataEntry<UUID>>
implements Consumer<E>,
Function<UUID, E> {
    private final UUID context = UUID.randomUUID();
    private final TimerConfiguration config;
    private final Duration originalLastTimeout = Duration.ZERO;
    private final Duration updatedLastTimeout = Duration.ofSeconds(1L);

    AbstractTimerMetaDataEntryTestCase(TimerConfiguration config) {
        this.config = config;
    }

    @Test
    public void test() {
        RemappableTimerMetaDataEntry entry = (RemappableTimerMetaDataEntry)this.apply(this.context);
        this.verifyDefaultState(entry);
        entry.setLastTimeout(this.originalLastTimeout);
        this.verifyOriginalState(entry);
        this.accept(entry);
    }

    void updateState(TimerMetaDataEntry<UUID> entry) {
        entry.setLastTimeout(this.updatedLastTimeout);
    }

    void verifyDefaultState(E entry) {
        Assert.assertEquals((Object)this.config.getStart(), (Object)entry.getStart());
        Assert.assertEquals((Object)this.context, (Object)entry.getContext());
        Assert.assertNull((Object)entry.getLastTimeout());
    }

    void verifyOriginalState(E entry) {
        Assert.assertEquals((Object)this.config.getStart(), (Object)entry.getStart());
        Assert.assertEquals((Object)this.context, (Object)entry.getContext());
        Assert.assertEquals((Object)this.originalLastTimeout, (Object)entry.getLastTimeout());
    }

    void verifyUpdatedState(E entry) {
        Assert.assertEquals((Object)this.config.getStart(), (Object)entry.getStart());
        Assert.assertEquals((Object)this.context, (Object)entry.getContext());
        Assert.assertEquals((Object)this.updatedLastTimeout, (Object)entry.getLastTimeout());
    }
}

