/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.ejb.cache.timer.DefaultImmutableTimerMetaData;
import org.wildfly.clustering.ejb.cache.timer.ImmutableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataConfiguration;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.TimerConfiguration;
import org.wildfly.clustering.ejb.timer.TimerType;
import org.wildfly.clustering.marshalling.spi.Marshaller;

public class DefaultImmutableTimerMetaDataTestCase {
    private final TimerMetaDataConfiguration<Object> config = (TimerMetaDataConfiguration)Mockito.mock(TimerMetaDataConfiguration.class);
    private final ImmutableTimerMetaDataEntry<Object> entry = (ImmutableTimerMetaDataEntry)Mockito.mock(ImmutableTimerMetaDataEntry.class);
    private final Marshaller<Object, Object> marshaller = (Marshaller)Mockito.mock(Marshaller.class);
    private ImmutableTimerMetaData metaData;

    @Before
    public void init() {
        ((TimerMetaDataConfiguration)Mockito.doReturn(this.marshaller).when(this.config)).getMarshaller();
        ((TimerMetaDataConfiguration)Mockito.doReturn((Object)true).when(this.config)).isPersistent();
        this.metaData = new DefaultImmutableTimerMetaData(this.config, this.entry);
    }

    @Test
    public void getType() {
        for (TimerType type : EnumSet.allOf(TimerType.class)) {
            ((ImmutableTimerMetaDataEntry)Mockito.doReturn((Object)type).when(this.entry)).getType();
            Assert.assertSame((Object)type, (Object)this.metaData.getType());
        }
    }

    @Test
    public void getContext() throws IOException {
        UUID marshalledContext = UUID.randomUUID();
        UUID context = UUID.randomUUID();
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn((Object)marshalledContext).when(this.entry)).getContext();
        ((Marshaller)Mockito.doReturn((Object)context).when(this.marshaller)).read((Object)marshalledContext);
        Assert.assertSame((Object)context, (Object)this.metaData.getContext());
    }

    @Test
    public void getTimeoutMatcher() {
        Predicate<Method> matcher = method -> true;
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn(matcher).when(this.entry)).getTimeoutMatcher();
        Assert.assertSame(matcher, (Object)this.metaData.getTimeoutMatcher());
    }

    @Test
    public void isPersistent() {
        Assert.assertTrue((boolean)this.metaData.isPersistent());
    }

    @Test
    public void getConfiguration() {
        Assert.assertSame(this.entry, (Object)this.metaData.getConfiguration(TimerConfiguration.class));
    }

    @Test
    public void getLastTimeout() {
        Instant start = Instant.now();
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn(null).when(this.entry)).getLastTimeout();
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn((Object)start).when(this.entry)).getStart();
        Optional result = this.metaData.getLastTimeout();
        Assert.assertFalse((boolean)result.isPresent());
        Duration lastTimeout = Duration.ofSeconds(10L);
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn((Object)lastTimeout).when(this.entry)).getLastTimeout();
        result = this.metaData.getLastTimeout();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)lastTimeout, (Object)Duration.between(start, (Temporal)result.get()));
    }

    @Test
    public void getNextTimeout() {
        Instant start = Instant.now();
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn(null).when(this.entry)).getLastTimeout();
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn((Object)start).when(this.entry)).getStart();
        Optional result = this.metaData.getNextTimeout();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertSame((Object)start, result.get());
        Duration lastTimeoutDuration = Duration.ofSeconds(10L);
        Instant lastTimeout = start.plus(lastTimeoutDuration);
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn((Object)lastTimeoutDuration).when(this.entry)).getLastTimeout();
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn(null).when(this.entry)).apply((Object)lastTimeout);
        result = this.metaData.getNextTimeout();
        Assert.assertFalse((boolean)result.isPresent());
        Instant nextTimeout = start.plus(Duration.ofMinutes(1L));
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn((Object)nextTimeout).when(this.entry)).apply((Object)lastTimeout);
        result = this.metaData.getNextTimeout();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertSame((Object)nextTimeout, result.get());
    }
}

