/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ejb.cache.bean.BeanMetaDataEntry;
import org.wildfly.clustering.ejb.cache.bean.DefaultBeanMetaDataEntry;
import org.wildfly.clustering.ejb.cache.bean.RemappableBeanMetaDataEntry;

public abstract class AbstractBeanMetaDataEntryTestCase
implements Consumer<RemappableBeanMetaDataEntry<UUID>> {
    private final Instant originalLastAccessed = Instant.now();
    private final Instant created = this.originalLastAccessed.minus(Duration.ofMinutes(1L));
    private final String name = "foo";
    private final UUID groupId = UUID.randomUUID();
    private final Instant updatedLastAccessed = this.originalLastAccessed.plus(Duration.ofSeconds(10L));

    @Test
    public void test() {
        DefaultBeanMetaDataEntry entry = new DefaultBeanMetaDataEntry(this.name, (Object)this.groupId, this.created);
        Assert.assertEquals((Object)this.name, (Object)entry.getName());
        Assert.assertEquals((Object)this.groupId, (Object)entry.getGroupId());
        Assert.assertEquals((Object)this.created, (Object)entry.getLastAccess().getBasis());
        Assert.assertEquals((Object)this.created, (Object)entry.getLastAccess().get());
        entry.getLastAccess().set((Object)this.originalLastAccessed);
        this.verifyOriginalState((BeanMetaDataEntry<UUID>)entry);
        this.accept(entry);
    }

    void updateState(BeanMetaDataEntry<UUID> entry) {
        entry.getLastAccess().set((Object)this.updatedLastAccessed);
    }

    void verifyOriginalState(BeanMetaDataEntry<UUID> entry) {
        Assert.assertEquals((Object)this.name, (Object)entry.getName());
        Assert.assertEquals((Object)this.groupId, (Object)entry.getGroupId());
        Assert.assertEquals((Object)this.originalLastAccessed, (Object)entry.getLastAccess().get());
    }

    void verifyUpdatedState(BeanMetaDataEntry<UUID> entry) {
        Assert.assertEquals((Object)this.name, (Object)entry.getName());
        Assert.assertEquals((Object)this.groupId, (Object)entry.getGroupId());
        Assert.assertEquals((Object)this.updatedLastAccessed, (Object)entry.getLastAccess().get());
    }
}

