/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.io.IOException;
import java.time.Duration;
import java.util.UUID;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.UUIDSessionID;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ee.cache.offset.Offset;
import org.wildfly.clustering.ejb.cache.bean.DefaultBeanMetaDataEntry;
import org.wildfly.clustering.ejb.cache.bean.RemappableBeanMetaDataEntry;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;

public class DefaultBeanMetaDataEntryMarshallerTestCase {
    @Test
    public void test() throws IOException {
        UUIDSessionID id = new UUIDSessionID(UUID.randomUUID());
        DefaultBeanMetaDataEntry metaData = new DefaultBeanMetaDataEntry("foo", (Object)id);
        MarshallingTester tester = ProtoStreamTesterFactory.INSTANCE.createTester();
        tester.test((Object)metaData, DefaultBeanMetaDataEntryMarshallerTestCase::assertEquals);
        metaData.getLastAccess().setOffset(Offset.forInstant((Duration)Duration.ofSeconds(1L)));
        tester.test((Object)metaData, DefaultBeanMetaDataEntryMarshallerTestCase::assertEquals);
    }

    static void assertEquals(RemappableBeanMetaDataEntry<SessionID> entry1, RemappableBeanMetaDataEntry<SessionID> entry2) {
        Assert.assertEquals((Object)entry1.getName(), (Object)entry2.getName());
        Assert.assertEquals((Object)entry1.getGroupId(), (Object)entry2.getGroupId());
        Assert.assertEquals((Object)entry1.getLastAccess().getBasis(), (Object)entry2.getLastAccess().getBasis());
        Assert.assertEquals((Object)entry1.getLastAccess().get(), (Object)entry2.getLastAccess().get());
    }
}

