/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.clustering.ejb.cache.timer.AbstractTimerMetaDataEntryTestCase;
import org.wildfly.clustering.ejb.cache.timer.DefaultTimeoutMatcher;
import org.wildfly.clustering.ejb.cache.timer.ImmutableScheduleExpressionMarshaller;
import org.wildfly.clustering.ejb.cache.timer.ScheduleTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimeoutDescriptor;
import org.wildfly.clustering.ejb.timer.ImmutableScheduleExpression;
import org.wildfly.clustering.ejb.timer.ScheduleTimerConfiguration;
import org.wildfly.clustering.ejb.timer.TimerConfiguration;

@RunWith(value=Parameterized.class)
public abstract class AbstractScheduleTimerMetaDataEntryTestCase
extends AbstractTimerMetaDataEntryTestCase<ScheduleTimerMetaDataEntry<UUID>> {
    private final ScheduleTimerConfiguration config;
    private final Method method;

    @Parameterized.Parameters
    public static Iterable<Map.Entry<ScheduleTimerConfiguration, Method>> parameters() {
        ImmutableScheduleExpression expression = (ImmutableScheduleExpression)ImmutableScheduleExpressionMarshaller.INSTANCE.createInitialValue().start(Instant.now()).end(Instant.now().plus(Duration.ofHours(1L))).year("1970").month("1").dayOfMonth("1").dayOfWeek("1").zone(ZoneId.of("GMT")).hour("0").minute("0").second("0").get();
        ScheduleTimerConfiguration config = () -> expression;
        try {
            Method method = AbstractScheduleTimerMetaDataEntryTestCase.class.getDeclaredMethod("ejbTimeout", new Class[0]);
            return List.of(new AbstractMap.SimpleImmutableEntry<ScheduleTimerConfiguration, Object>(config, null), Map.entry(config, method));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    AbstractScheduleTimerMetaDataEntryTestCase(Map.Entry<ScheduleTimerConfiguration, Method> entry) {
        super((TimerConfiguration)entry.getKey());
        this.config = entry.getKey();
        this.method = entry.getValue();
    }

    @Override
    public ScheduleTimerMetaDataEntry<UUID> apply(UUID context) {
        return this.method != null ? new ScheduleTimerMetaDataEntry((Object)context, this.config, this.method) : new ScheduleTimerMetaDataEntry((Object)context, this.config);
    }

    @Override
    void verifyDefaultState(ScheduleTimerMetaDataEntry<UUID> entry) {
        super.verifyDefaultState(entry);
        this.verifyState(entry);
    }

    @Override
    void verifyOriginalState(ScheduleTimerMetaDataEntry<UUID> entry) {
        super.verifyOriginalState(entry);
        this.verifyState(entry);
    }

    @Override
    void verifyUpdatedState(ScheduleTimerMetaDataEntry<UUID> entry) {
        super.verifyUpdatedState(entry);
        this.verifyState(entry);
    }

    private void verifyState(ScheduleTimerMetaDataEntry<UUID> entry) {
        Assert.assertEquals((Object)this.config.getScheduleExpression().getStart(), (Object)entry.getScheduleExpression().getStart());
        Assert.assertEquals((Object)this.config.getScheduleExpression().getEnd(), (Object)entry.getScheduleExpression().getEnd());
        Assert.assertEquals((Object)this.config.getScheduleExpression().getYear(), (Object)entry.getScheduleExpression().getYear());
        Assert.assertEquals((Object)this.config.getScheduleExpression().getMonth(), (Object)entry.getScheduleExpression().getMonth());
        Assert.assertEquals((Object)this.config.getScheduleExpression().getDayOfMonth(), (Object)entry.getScheduleExpression().getDayOfMonth());
        Assert.assertEquals((Object)this.config.getScheduleExpression().getDayOfWeek(), (Object)entry.getScheduleExpression().getDayOfWeek());
        Assert.assertEquals((Object)this.config.getScheduleExpression().getHour(), (Object)entry.getScheduleExpression().getHour());
        Assert.assertEquals((Object)this.config.getScheduleExpression().getMinute(), (Object)entry.getScheduleExpression().getMinute());
        Assert.assertEquals((Object)this.config.getScheduleExpression().getSecond(), (Object)entry.getScheduleExpression().getSecond());
        Assert.assertEquals((Object)this.config.getScheduleExpression().getZone(), (Object)entry.getScheduleExpression().getZone());
        if (this.method != null) {
            Assert.assertEquals((Object)new TimeoutDescriptor(this.method), (Object)entry.getTimeoutMatcher());
        } else {
            Assert.assertSame((Object)DefaultTimeoutMatcher.INSTANCE, (Object)entry.getTimeoutMatcher());
        }
    }

    void ejbTimeout() {
    }
}

