/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.clustering.ejb.cache.timer.AbstractTimerMetaDataEntryTestCase;
import org.wildfly.clustering.ejb.cache.timer.DefaultTimeoutMatcher;
import org.wildfly.clustering.ejb.cache.timer.IntervalTimerMetaDataEntry;
import org.wildfly.clustering.ejb.timer.IntervalTimerConfiguration;
import org.wildfly.clustering.ejb.timer.TimerConfiguration;
import org.wildfly.clustering.ejb.timer.TimerType;

@RunWith(value=Parameterized.class)
public abstract class AbstractIntervalTimerMetaDataEntryTestCase
extends AbstractTimerMetaDataEntryTestCase<IntervalTimerMetaDataEntry<UUID>> {
    private final IntervalTimerConfiguration config;

    @Parameterized.Parameters
    public static Iterable<IntervalTimerConfiguration> parameters() {
        final Instant start = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        return List.of(new IntervalTimerConfiguration(){

            public Instant getStart() {
                return start;
            }
        }, new IntervalTimerConfiguration(){

            public Instant getStart() {
                return start;
            }

            public Duration getInterval() {
                return Duration.ofSeconds(10L);
            }
        });
    }

    AbstractIntervalTimerMetaDataEntryTestCase(IntervalTimerConfiguration config) {
        super((TimerConfiguration)config);
        this.config = config;
    }

    @Override
    public IntervalTimerMetaDataEntry<UUID> apply(UUID context) {
        return new IntervalTimerMetaDataEntry((Object)context, this.config);
    }

    @Override
    void verifyDefaultState(IntervalTimerMetaDataEntry<UUID> entry) {
        super.verifyDefaultState(entry);
        this.verifyState(entry);
    }

    @Override
    void verifyOriginalState(IntervalTimerMetaDataEntry<UUID> entry) {
        super.verifyOriginalState(entry);
        this.verifyState(entry);
    }

    @Override
    void verifyUpdatedState(IntervalTimerMetaDataEntry<UUID> entry) {
        super.verifyUpdatedState(entry);
        this.verifyState(entry);
    }

    private void verifyState(IntervalTimerMetaDataEntry<UUID> entry) {
        Assert.assertSame((Object)TimerType.INTERVAL, (Object)entry.getType());
        Assert.assertSame((Object)DefaultTimeoutMatcher.INSTANCE, (Object)entry.getTimeoutMatcher());
        Assert.assertEquals((Object)this.config.getInterval(), (Object)entry.getInterval());
    }
}

