/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.wildfly.clustering.ejb.cache.timer.ImmutableScheduleExpressionMarshaller;
import org.wildfly.clustering.ejb.cache.timer.ScheduleTimerMetaDataEntry;
import org.wildfly.clustering.ejb.timer.ImmutableScheduleExpression;
import org.wildfly.clustering.ejb.timer.ScheduleTimerConfiguration;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValue;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;

public class ScheduleTimerMetaDataEntryMarshallerTestCase {
    @ParameterizedTest
    @TesterFactorySource(value={MarshallingTesterFactory.class})
    public void test(MarshallingTesterFactory factory) throws NoSuchMethodException {
        ByteBufferMarshalledValue context = new ByteBufferMarshalledValueFactory(factory.getMarshaller()).createMarshalledValue((Object)UUID.randomUUID());
        Tester tester = factory.createTester(ScheduleTimerMetaDataEntryMarshallerTestCase::assertEquals);
        tester.accept((Object)new ScheduleTimerMetaDataEntry((Object)context, new ScheduleTimerConfiguration(){

            public ImmutableScheduleExpression getScheduleExpression() {
                return (ImmutableScheduleExpression)ImmutableScheduleExpressionMarshaller.INSTANCE.createInitialValue().get();
            }
        }));
        final Instant start = Instant.now();
        final Instant end = start.plus(Duration.ofDays(10L));
        tester.accept((Object)new ScheduleTimerMetaDataEntry((Object)context, new ScheduleTimerConfiguration(){

            public ImmutableScheduleExpression getScheduleExpression() {
                return (ImmutableScheduleExpression)ImmutableScheduleExpressionMarshaller.INSTANCE.createInitialValue().start(start).end(end).year("1970").month("1").dayOfMonth("1").dayOfWeek("1").zone(ZoneId.of("GMT")).hour("0").minute("0").second("0").get();
            }
        }, ScheduleTimerMetaDataEntryMarshallerTestCase.class.getDeclaredMethod("timeout", new Class[0])));
        tester.accept((Object)new ScheduleTimerMetaDataEntry((Object)context, new ScheduleTimerConfiguration(){

            public ImmutableScheduleExpression getScheduleExpression() {
                return (ImmutableScheduleExpression)ImmutableScheduleExpressionMarshaller.INSTANCE.createInitialValue().start(start).end(end).year("1970").month("JAN").dayOfMonth("1").dayOfWeek("TUES").zone(ZoneId.of("America/New_York")).hour("0").minute("0").second("0").get();
            }
        }, ScheduleTimerMetaDataEntryMarshallerTestCase.class.getDeclaredMethod("ejbTimeout", new Class[0])));
        tester.accept((Object)new ScheduleTimerMetaDataEntry((Object)context, new ScheduleTimerConfiguration(){

            public ImmutableScheduleExpression getScheduleExpression() {
                return (ImmutableScheduleExpression)ImmutableScheduleExpressionMarshaller.INSTANCE.createInitialValue().start(start).end(end).year("1970").month("JAN").dayOfMonth("1").dayOfWeek("TUES").zone(ZoneId.of("America/New_York")).hour("0").minute("0").second("0").get();
            }
        }, ScheduleTimerMetaDataEntryMarshallerTestCase.class.getDeclaredMethod("ejbTimeout", Object.class)));
    }

    void timeout() {
    }

    void ejbTimeout() {
    }

    void ejbTimeout(Object timer) {
    }

    private static <V> void assertEquals(ScheduleTimerMetaDataEntry<V> entry1, ScheduleTimerMetaDataEntry<V> entry2) {
        Assertions.assertEquals((Object)entry1.getContext(), (Object)entry2.getContext());
        Assertions.assertEquals((Object)entry1.getStart(), (Object)entry2.getStart());
        Assertions.assertEquals((Object)entry1.getTimeoutMatcher(), (Object)entry2.getTimeoutMatcher());
        Assertions.assertSame((Object)entry1.getType(), (Object)entry2.getType());
        Assertions.assertEquals((Object)entry1.getScheduleExpression().getStart(), (Object)entry2.getScheduleExpression().getStart());
        Assertions.assertEquals((Object)entry1.getScheduleExpression().getEnd(), (Object)entry2.getScheduleExpression().getEnd());
        Assertions.assertEquals((Object)entry1.getScheduleExpression().getYear(), (Object)entry2.getScheduleExpression().getYear());
        Assertions.assertEquals((Object)entry1.getScheduleExpression().getMonth(), (Object)entry2.getScheduleExpression().getMonth());
        Assertions.assertEquals((Object)entry1.getScheduleExpression().getDayOfMonth(), (Object)entry2.getScheduleExpression().getDayOfMonth());
        Assertions.assertEquals((Object)entry1.getScheduleExpression().getDayOfWeek(), (Object)entry2.getScheduleExpression().getDayOfWeek());
        Assertions.assertEquals((Object)entry1.getScheduleExpression().getZone(), (Object)entry2.getScheduleExpression().getZone());
        Assertions.assertEquals((Object)entry1.getScheduleExpression().getHour(), (Object)entry2.getScheduleExpression().getHour());
        Assertions.assertEquals((Object)entry1.getScheduleExpression().getMinute(), (Object)entry2.getScheduleExpression().getMinute());
        Assertions.assertEquals((Object)entry1.getScheduleExpression().getSecond(), (Object)entry2.getScheduleExpression().getSecond());
    }
}

