/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.bean;

import java.time.Duration;
import java.util.UUID;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.UUIDSessionID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.wildfly.clustering.ejb.cache.bean.DefaultBeanMetaDataEntry;
import org.wildfly.clustering.ejb.cache.bean.RemappableBeanMetaDataEntry;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.TesterFactory;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;
import org.wildfly.clustering.server.offset.Offset;

public class DefaultBeanMetaDataEntryMarshallerTestCase {
    @ParameterizedTest
    @TesterFactorySource(value={MarshallingTesterFactory.class})
    public void test(TesterFactory factory) {
        UUIDSessionID id = new UUIDSessionID(UUID.randomUUID());
        DefaultBeanMetaDataEntry metaData = new DefaultBeanMetaDataEntry("foo", (Object)id);
        Tester tester = factory.createTester(DefaultBeanMetaDataEntryMarshallerTestCase::assertEquals);
        tester.accept((Object)metaData);
        metaData.getLastAccess().setOffset(Offset.forInstant((Duration)Duration.ofSeconds(1L)));
        tester.accept((Object)metaData);
    }

    static void assertEquals(RemappableBeanMetaDataEntry<SessionID> entry1, RemappableBeanMetaDataEntry<SessionID> entry2) {
        Assertions.assertEquals((Object)entry1.getName(), (Object)entry2.getName());
        Assertions.assertEquals((Object)entry1.getGroupId(), (Object)entry2.getGroupId());
        Assertions.assertEquals((Object)entry1.getLastAccess().getBasis(), (Object)entry2.getLastAccess().getBasis());
        Assertions.assertEquals((Object)entry1.getLastAccess().get(), (Object)entry2.getLastAccess().get());
    }
}

