/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.wildfly.clustering.ejb.cache.timer.IntervalTimerMetaDataEntry;
import org.wildfly.clustering.ejb.timer.IntervalTimerConfiguration;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValue;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;

public class IntervalTimerMetaDataEntryMarshallerTestCase {
    @ParameterizedTest
    @TesterFactorySource(value={MarshallingTesterFactory.class})
    public void test(MarshallingTesterFactory factory) {
        ByteBufferMarshalledValue context = new ByteBufferMarshalledValueFactory(factory.getMarshaller()).createMarshalledValue((Object)UUID.randomUUID());
        Tester tester = factory.createTester(IntervalTimerMetaDataEntryMarshallerTestCase::assertEquals);
        tester.accept((Object)new IntervalTimerMetaDataEntry((Object)context, new IntervalTimerConfiguration(){

            public Instant getStart() {
                return Instant.now();
            }
        }));
        tester.accept((Object)new IntervalTimerMetaDataEntry((Object)context, new IntervalTimerConfiguration(){

            public Instant getStart() {
                return Instant.now();
            }

            public Duration getInterval() {
                return Duration.ofMinutes(1L);
            }
        }));
    }

    private static <V> void assertEquals(IntervalTimerMetaDataEntry<V> entry1, IntervalTimerMetaDataEntry<V> entry2) {
        Assertions.assertEquals((Object)entry1.getContext(), (Object)entry2.getContext());
        Assertions.assertEquals((Object)entry1.getInterval(), (Object)entry2.getInterval());
        Assertions.assertEquals((Object)entry1.getStart(), (Object)entry2.getStart());
        Assertions.assertSame((Object)entry1.getTimeoutMatcher(), (Object)entry2.getTimeoutMatcher());
        Assertions.assertSame((Object)entry1.getType(), (Object)entry2.getType());
    }
}

