/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.cache.timer;

import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.ejb.cache.timer.ImmutableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.MutableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataEntry;
import org.wildfly.clustering.ejb.timer.TimerType;
import org.wildfly.clustering.server.offset.OffsetValue;

public class MutableTimerMetaDataEntryTestCase {
    private final ImmutableTimerMetaDataEntry<UUID> entry = (ImmutableTimerMetaDataEntry)Mockito.mock(ImmutableTimerMetaDataEntry.class);
    private final OffsetValue<Duration> lastTimeoutValue = (OffsetValue)Mockito.mock(OffsetValue.class);
    private final TimerMetaDataEntry<UUID> subject = new MutableTimerMetaDataEntry(this.entry, this.lastTimeoutValue);

    @Test
    public void getType() {
        for (TimerType type : EnumSet.allOf(TimerType.class)) {
            ((ImmutableTimerMetaDataEntry)Mockito.doReturn((Object)type).when(this.entry)).getType();
            Mockito.verifyNoInteractions((Object[])new Object[]{this.lastTimeoutValue});
            Assert.assertSame((Object)type, (Object)this.subject.getType());
        }
    }

    @Test
    public void getContext() {
        UUID expected = UUID.randomUUID();
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn((Object)expected).when(this.entry)).getContext();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.lastTimeoutValue});
        Assert.assertSame((Object)expected, (Object)this.subject.getContext());
    }

    @Test
    public void getStart() {
        Instant expected = Instant.now();
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn((Object)expected).when(this.entry)).getStart();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.entry});
        Assert.assertSame((Object)expected, (Object)this.subject.getStart());
    }

    @Test
    public void getTimeoutMatcher() {
        Predicate<Method> expected = method -> true;
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn(expected).when(this.entry)).getTimeoutMatcher();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.entry});
        Assert.assertSame(expected, (Object)this.subject.getTimeoutMatcher());
    }

    @Test
    public void getLastTimeout() {
        Duration expected = Duration.ofSeconds(10L);
        ((OffsetValue)Mockito.doReturn((Object)expected).when(this.lastTimeoutValue)).get();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.entry});
        Assert.assertSame((Object)expected, (Object)this.subject.getLastTimeout());
    }

    @Test
    public void setLastTimeout() {
        Duration timeout = Duration.ofSeconds(10L);
        this.subject.setLastTimeout(timeout);
        ((OffsetValue)Mockito.verify(this.lastTimeoutValue)).set((Object)timeout);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.entry});
    }

    @Test
    public void apply() {
        Instant now = Instant.now();
        Instant expected = now.plus(Duration.ofMinutes(1L));
        ((ImmutableTimerMetaDataEntry)Mockito.doReturn((Object)expected).when(this.entry)).apply((Object)now);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.lastTimeoutValue});
        Assert.assertSame((Object)expected, (Object)this.subject.apply((Object)now));
    }
}

