/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.UUIDSessionID;
import org.junit.Test;
import org.wildfly.clustering.ejb.client.SessionIDSerializer;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.ExternalizerTesterFactory;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;

public class SessionIDSerializerTestCase {
    @Test
    public void testProtoStream() throws IOException {
        SessionIDSerializerTestCase.test((Tester<SessionID>)ProtoStreamTesterFactory.INSTANCE.createTester());
    }

    @Test
    public void testExternalizer() throws IOException {
        SessionIDSerializerTestCase.test((Tester<SessionID>)new ExternalizerTesterFactory(new Externalizer[]{new SessionIDSerializer.UUIDSessionIDExternalizer(), new SessionIDSerializer.BasicSessionIDExternalizer(), new SessionIDSerializer.UnknownSessionIDExternalizer()}).createTester());
    }

    private static void test(Tester<SessionID> tester) throws IOException {
        UUID uuid = UUID.randomUUID();
        tester.test((Object)new UUIDSessionID(uuid));
        ByteBuffer buffer = ByteBuffer.allocate(20);
        buffer.putInt(0x7000000);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        tester.test((Object)SessionID.createSessionID((byte[])buffer.array()));
        buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        tester.test((Object)SessionID.createSessionID((byte[])buffer.array()));
    }
}

