/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.ejb;

import java.io.InputStream;
import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.AbstractSubsystemSchemaTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.wildfly.clustering.infinispan.service.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.service.InfinispanDefaultCacheRequirement;
import org.wildfly.clustering.service.BinaryRequirement;
import org.wildfly.clustering.service.UnaryRequirement;
import org.wildfly.extension.clustering.ejb.BeanManagementResourceDefinition;
import org.wildfly.extension.clustering.ejb.ClientMappingsRegistryProviderResourceDefinition;
import org.wildfly.extension.clustering.ejb.DistributableEjbExtension;
import org.wildfly.extension.clustering.ejb.DistributableEjbResourceDefinition;
import org.wildfly.extension.clustering.ejb.DistributableEjbSubsystemSchema;
import org.wildfly.extension.clustering.ejb.InfinispanBeanManagementResourceDefinition;
import org.wildfly.extension.clustering.ejb.InfinispanClientMappingsRegistryProviderResourceDefinition;
import org.wildfly.extension.clustering.ejb.InfinispanTimerManagementResourceDefinition;
import org.wildfly.extension.clustering.ejb.LocalClientMappingsRegistryProviderResourceDefinition;

@RunWith(value=Parameterized.class)
public class DistributableEjbSubsystemTestCase
extends AbstractSubsystemSchemaTest<DistributableEjbSubsystemSchema> {
    @Parameterized.Parameters
    public static Iterable<DistributableEjbSubsystemSchema> parameters() {
        return EnumSet.allOf(DistributableEjbSubsystemSchema.class);
    }

    public DistributableEjbSubsystemTestCase(DistributableEjbSubsystemSchema schema) {
        super("distributable-ejb", (Extension)new DistributableEjbExtension(), (SubsystemSchema)schema, (SubsystemSchema)DistributableEjbSubsystemSchema.CURRENT);
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return new org.jboss.as.clustering.subsystem.AdditionalInitialization().require((UnaryRequirement)InfinispanDefaultCacheRequirement.CONFIGURATION, new String[]{"foo"}).require((BinaryRequirement)InfinispanCacheRequirement.CONFIGURATION, "foo", "bar");
    }

    @Test
    public void testInfinispanBeanManagement() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices ks = this.createKernelServicesBuilder(this.createAdditionalInitialization()).setSubsystemXml(subsystemXml).build();
        Assert.assertTrue((String)"Subsystem boot failed!", (boolean)ks.isSuccessfulBoot());
        PathAddress distributableEjbAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{DistributableEjbResourceDefinition.PATH});
        PathAddress anotherBeanManagementProviderAddress = distributableEjbAddress.append(new PathElement[]{InfinispanBeanManagementResourceDefinition.pathElement((String)"another-bean-management-provider")});
        ModelNode anotherBeanManagementProvider = Util.createAddOperation((PathAddress)anotherBeanManagementProviderAddress);
        anotherBeanManagementProvider.get(InfinispanBeanManagementResourceDefinition.Attribute.CACHE_CONTAINER.getName()).set("foo");
        anotherBeanManagementProvider.get(InfinispanBeanManagementResourceDefinition.Attribute.CACHE.getName()).set("bar");
        anotherBeanManagementProvider.get(BeanManagementResourceDefinition.Attribute.MAX_ACTIVE_BEANS.getName()).set(11);
        ModelNode addResponse = ks.executeOperation(anotherBeanManagementProvider, new InputStream[0]);
        Assert.assertEquals((String)addResponse.toString(), (Object)"success", (Object)addResponse.get("outcome").asString());
        ModelNode readMaxActiveBeansAttribute = Util.getReadAttributeOperation((PathAddress)anotherBeanManagementProviderAddress, (String)BeanManagementResourceDefinition.Attribute.MAX_ACTIVE_BEANS.getName());
        ModelNode readMaxActiveBeansResult = ks.executeOperation(readMaxActiveBeansAttribute, new InputStream[0]);
        Assert.assertEquals((String)readMaxActiveBeansResult.toString(), (Object)"success", (Object)readMaxActiveBeansResult.get("outcome").asString());
        Assert.assertEquals((String)readMaxActiveBeansResult.toString(), (long)11L, (long)readMaxActiveBeansResult.get("result").asInt());
        ModelNode removeAnotherBeanManagementProvider = Util.createRemoveOperation((PathAddress)anotherBeanManagementProviderAddress);
        ModelNode removeResponse = ks.executeOperation(removeAnotherBeanManagementProvider, new InputStream[0]);
        Assert.assertEquals((String)removeResponse.toString(), (Object)"success", (Object)removeResponse.get("outcome").asString());
    }

    @Test
    public void testClientMappingsRegistry() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices ks = this.createKernelServicesBuilder(this.createAdditionalInitialization()).setSubsystemXml(subsystemXml).build();
        Assert.assertTrue((String)"Subsystem boot failed!", (boolean)ks.isSuccessfulBoot());
        PathAddress distributableEjbAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{DistributableEjbResourceDefinition.PATH});
        PathAddress infinispanClientMappingsRegistryProviderAddress = distributableEjbAddress.append(new PathElement[]{ClientMappingsRegistryProviderResourceDefinition.pathElement((String)"infinispan")});
        ModelNode addInfinispanClientMappingsRegistryProvider = Util.createAddOperation((PathAddress)infinispanClientMappingsRegistryProviderAddress);
        addInfinispanClientMappingsRegistryProvider.get(InfinispanClientMappingsRegistryProviderResourceDefinition.Attribute.CACHE_CONTAINER.getName()).set("foo");
        addInfinispanClientMappingsRegistryProvider.get(InfinispanClientMappingsRegistryProviderResourceDefinition.Attribute.CACHE.getName()).set("bar");
        ModelNode addResponse = ks.executeOperation(addInfinispanClientMappingsRegistryProvider, new InputStream[0]);
        Assert.assertEquals((String)addResponse.toString(), (Object)"success", (Object)addResponse.get("outcome").asString());
        ModelNode distributableEjbSubsystem = ks.readWholeModel().get(DistributableEjbResourceDefinition.PATH.getKeyValuePair());
        ModelNode localClientMappingsRegistryProvider = distributableEjbSubsystem.get(LocalClientMappingsRegistryProviderResourceDefinition.PATH.getKeyValuePair());
        ModelNode infinispanClientMappingsRegistryProvider = distributableEjbSubsystem.get(InfinispanClientMappingsRegistryProviderResourceDefinition.PATH.getKeyValuePair());
        Assert.assertEquals((String)localClientMappingsRegistryProvider.toString(), (Object)false, (Object)localClientMappingsRegistryProvider.isDefined());
        Assert.assertEquals((String)infinispanClientMappingsRegistryProvider.toString(), (Object)true, (Object)infinispanClientMappingsRegistryProvider.isDefined());
    }

    @Test
    public void testExpressions() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices ks = this.createKernelServicesBuilder(this.createAdditionalInitialization()).setSubsystemXml(subsystemXml).build();
        Assert.assertTrue((String)"Subsystem boot failed!", (boolean)ks.isSuccessfulBoot());
        ModelNode subsystem = ks.readWholeModel().get(DistributableEjbResourceDefinition.PATH.getKeyValuePair());
        ModelNode beanManagement = subsystem.get(InfinispanBeanManagementResourceDefinition.pathElement((String)"default").getKeyValuePair());
        int maxActiveBeans = beanManagement.get(BeanManagementResourceDefinition.Attribute.MAX_ACTIVE_BEANS.getName()).resolve().asInt();
        Assert.assertEquals((long)10000L, (long)maxActiveBeans);
        ModelNode persistentTimerManagement = subsystem.get(InfinispanTimerManagementResourceDefinition.pathElement((String)"distributed").getKeyValuePair());
        Assert.assertEquals((long)100L, (long)persistentTimerManagement.get(InfinispanTimerManagementResourceDefinition.Attribute.MAX_ACTIVE_TIMERS.getName()).resolve().asInt());
        ModelNode transientTimerManagement = subsystem.get(InfinispanTimerManagementResourceDefinition.pathElement((String)"transient").getKeyValuePair());
        Assert.assertEquals((long)1000L, (long)transientTimerManagement.get(InfinispanTimerManagementResourceDefinition.Attribute.MAX_ACTIVE_TIMERS.getName()).resolve().asInt());
    }
}

